const tableAdaptive = function (options) {
	// console.log(options.tables);
	let tables = options.tables;

	// Создание ячейки с кнопкой
	// Обработчик на кнопке
	function insertMoreBtn() {
		let td = document.createElement('TD');
		td.classList.add('last');
		td.innerHTML = '<a data-text="Скрыть" class="btn btn_secondary btn_sm" href="/">Подробнее</a>';
		
		let link = td.querySelector('a'); 
		link.addEventListener('click', (e)=>{
			e.preventDefault();
			let element = e.target;
			let parent = element.closest('tr');
			parent.classList.toggle('full');

			let btnText = element.textContent;
			element.textContent = element.dataset.text;
			element.dataset.text = btnText;
		})

		return td;
	}

	tables.forEach(function (item) {
		let headerInfo = [];
		let headers = item.querySelectorAll("th");
		let tablebody = item.querySelector("tbody");

		headers.forEach((header)=>{
			headerInfo.push({
				text: header.textContent.replace(/\r?\n|\r/,""),
				hidden: !header.hasAttribute('data-col-shown')
			})
		})

		Array.prototype.forEach.call(tablebody.rows, (row)=> {
			let moreBtn = false;
			Array.prototype.forEach.call(row.cells, (cell, i)=> {
				cell.setAttribute("data-th", headerInfo[i].text);
				if (headerInfo[i].hidden) {
					cell.classList.add("hidden");
					// Если хотя бы одна ячейка скрыта
					// показываем кнопку
					moreBtn = true; 
				}
			})

			if (moreBtn) {
				row.appendChild(insertMoreBtn());
			}
		})


	});
}

module.exports = tableAdaptive;