import axios from 'axios';
import $ from 'jquery';
import { async } from 'q';

Vue.component('utilization-total', {
	data: function () {
    return {
			wPrices: {
				wasteTotalPrice: "0",
				TransportTotalPrice: "0"
			}
    }
  },
  props: {
    record: {
      type: Object
    }
	},
	computed: {
		wasteTotalPrice : function () {
			var totalPrice = Number(0);

			for (var id in this.record) {

				if (this.record[id]["wCost"]) {
					var price = this.record[id]["wCost"]["value"];
					totalPrice += Number(price);
				}
			}

			return totalPrice;
		},
		TransportTotalPrice : function () {
			let totalPrice = Number(0);
			
			for (var id in this.record) {

				if (this.record[id]["wTransportCost"]) {
					var price = this.record[id]["wTransportCost"]["value"];
					totalPrice += Number(price);
				}
			}

			return totalPrice;
		},
	},
	methods: {
		final(){

			var formData = new FormData();
			let i = 0;

			var wDocs;

			wDocs = {};

			for (let recordItem in this.record){

				wDocs[recordItem] = {};

				this.record[recordItem].wDocs.forEach(element => {
				
					formData.append("file-" + i, element);
					wDocs[recordItem][i] = element.name;
					++i;
	
				});
			}

			var request = new XMLHttpRequest();
			request.open("POST", "app/");
			request.send(formData);

			
			var form = document.createElement("form");
			var element1 = document.createElement("input"); 
			var element2 = document.createElement("input"); 

			form.method = "POST";
			form.action = "app/";   
		
			element1.value=JSON.stringify(this.record);
			element1.name="orders";
			form.appendChild(element1);  

			element2.value=JSON.stringify(wDocs);
			element2.name="docs";
			form.appendChild(element2);  
		
			document.body.appendChild(form);
			form.submit();
		
		},
		RemoveAll() {
			this.$emit('RemoveAll');
		},
	},
	template: `
		<div id="utilization-total" class="utilization-total">
			<div data-target-id="utilization-total" data-target-class-toggle="hidden" class="utilization-total__toggle toggler">
				<div class="utilization-total__toggle-wrap">
					<div class="utilization-total__toggle-close">
						<span class="icon  i-arrow-down"></span>
					</div>
					<div class="utilization-total__toggle-open">
						<span class="icon  i-ellipsis"></span>
					</div>
				</div>
			</div>
			<div class="utilization-total__utilization-cost">
				<div class="utilization-total__item">
					<span class="iconsvg">
						<svg style="width: 24px; height: 23px; fill: rgb(77, 77, 77);">
							<use xlink:href="/local/templates/ecouniversal/img/sprite.svg#recycling"></use>
						</svg>
					</span>
					<span>Стоимость <br>утилизации отходов</span>
				</div>
				<div class="utilization-total__item">
					<span class="utilization-total__val">{{wasteTotalPrice}} руб.</span>
				</div>
			</div>
			<div class="utilization-total__delivery-cost">
				<div class="utilization-total__item">
					<span class="iconsvg">
						<svg style="width: 30px; height: 18px; fill: rgb(77, 77, 77);">
							<use xlink:href="/local/templates/ecouniversal/img/sprite.svg#delivery"></use>
						</svg>
					</span>
					<span>Стоимость <br>транспортировки</span>
				</div>
				<div class="utilization-total__item">
					<span class="utilization-total__val">{{TransportTotalPrice}} руб.</span>
				</div>
			</div>
			<a href="" class="utilization-total__summary-cost">
				<div class="utilization-total__item">
					<span class="iconsvg">
						<svg style="width: 17px; height: 20px; fill: rgb(255, 255, 255);">
							<use xlink:href="/local/templates/ecouniversal/img/sprite.svg#rubl"></use>
						</svg>
					</span>
					<span>Общая стоимость</span>
				</div>
				<div class="utilization-total__item utilization-total__item_col">
					<span class="utilization-total__val">{{wasteTotalPrice + TransportTotalPrice}} руб.</span>
					<span class="utilization-total__nds">в том числе НДС - 20%</span>
				</div>
			</a>
			<div class="utilization-total__btn">
				<div class="utilization-total__item">
					<form method="post" id="ajax_form" action="#">
						<button type="button" class="btn  btn_primary" @click="final()">Закать</button>
					</form>
				</div>
			</div>
		</div>
	`
})