const ready = require('../../js/utils/documentReady.js');

ready(function(){

	let mobileMenu = document.querySelector('#mobile-menu');
	let mobileMenuClose = mobileMenu.querySelector('.mobile-menu__close');
	let mobileMenuOverlay = mobileMenu.querySelector('.mobile-menu__overlay');

	function mobileMenuClosing() {

		document.getElementById('mobile-menu').classList.toggle('mobile-menu_shown');
		document.body.classList.toggle('menu-open');
	}
	
	mobileMenuClose.addEventListener('click', function () {
		mobileMenuClosing();
	});
	mobileMenuOverlay.addEventListener('click', function () {
		mobileMenuClosing();
	});

	document.addEventListener('keyup', function (e) {
		let mobileMenuOpened = mobileMenu.classList.contains('mobile-menu_shown');

		if (e.keyCode === 27 && mobileMenuOpened) {
			mobileMenuClosing();
		}

	})

});
