Vue.component('waste-filter', {
	props: {
		value: {
			type: String
		}
	},
	data: function () {
		return {
			wasteType: {
				'communal': 'Сбор коммунальных отходов',
				'fluid': 'Вывоз жидких отходов',
				'industrial': 'Утилизация промышленных отходов',
				'medical': 'Обезвреживание медицинских отходов',
				'lamps': 'Утилизация ртутных ламп'
			},
			activeItem: this.value
		}
	},
	computed: {
		getIconUrl() {
			return '/local/templates/ecouniversal/img/sprite.svg#'
		}
	},
	methods: {
		onChange(e) {
			this.$emit('change', {name: e.target.value, caption: e.target.dataset.caption})
		}
	},
	template: `
		<div class="filter">
			<label 
					v-for="(value, name) in wasteType"
					class="filter__item"
					v-bind:class="['filter__item_' + name, name == activeItem ? 'active' : '']"
					
			>
				<svg>
					<use :xlink:href="getIconUrl + name"></use>
				</svg>
				<span>{{value}}</span>
				<input	type="radio" 
								:value="name"
								:data-caption="value"
								v-model="activeItem"
								@change="onChange"
				>
			</label>
		</div>
	`
})