Vue.component('field-text',{
	props: ['title','value', 'placeholder', 'error'],
	data: function () {
		return {
			innerValue: ''
		}
	},
	watch: {
		innerValue (val) {
			this.$emit('input', val)
		}
	},
	template: `
		<label class="field-text">
			<span class="field-text__name">{{ title }} <span style="color: red;">*</span></span>
			<span class="field-text__input-wrap">
				<input 	type="text" 
								class="field-text__input"
								:placeholder="placeholder"
								v-model="innerValue"
								:value="value"
				>
			</span>
		</label>
	`
})