import Choices from "choices.js";
// eslint-disable-next-line no-undef
Vue.component('field-select', {
	props: {
		title: {
			type: String
		},
		attrs: {
			type: Object
		},
		options: {
			type: Array
		},
		settings: {
			type: Object
		},
		helptext: {
			type: String
		},
		init: {
			type: Object
		},
		showDropProp: {
			type: Boolean
		}
	},
	model: {
		prop: 'attrs.value',
		event: 'change'
	},
	data: 
		function () {
			return {
				choices: null,
				showDrop: this.showDropProp,
			}
	},
	mounted() {
		this.choicesInit();
	},
	computed: {
	},
	watch: {
		showDropProp: function() {
			this.choices.showDropdown();
		},
		options: 'choicesUpdate', //отслеживаем изменение объекта с опциями
	},
	methods: {
		showDrop() {
			return this.showDrop;
		},
		choicesInit() {
			this.choices = new Choices(this.$refs.select, this.settings);
		},
		choicesUpdate() {

			//console.log('Пришли изменения опций', this.init.value);

			if (this.init.value == undefined) this.choices.clearStore();

			//console.log('Пришли изменения настроек', JSON.stringify(this.settings));
			//alert(JSON.stringify(this.options));
			// при изменении опций селекта нужно принудительно обновить Choices
			this.choices.setChoices(this.options, 'value', 'label', true);
			this.choices.setChoiceByValue(this.init.value);
			
			// отправляем об этом сигнал родителю
			//this.$emit('change', {value: this.$refs.select.value, caption: this.$refs.select.querySelector('option[selected]').innerText.trim()})
		},
		selectChanged(e) {
			this.$emit('change', {value: e.target.value, caption: e.target.querySelector('option[selected]').innerText.trim()})
		},
	},
	template: `
		<div class="field-select">

			<div class="field-select__name" v-if="title">
				{{ title }}
				<span v-if="attrs.required"
							style="color: red;"
				>*</span>
			</div>
			<div class="field-select__select-wrap">
				<select ref="select" 
					class="field-select__select" 
					:name="attrs.name" 
					:id="attrs.id"
					:value="init.value"
					@change="selectChanged"
				>
	
					<template v-for="(option,index) in options">
						<template v-if="option.choices">
							<optgroup v-bind:label="option.label">
							
								<option v-for="childOption in option.choices" 
									:value="childOption.value"
									:selected="childOption.selected"
									:disabled="childOption.disabled"
								>
									{{ childOption.label }}
								</option>

							</optgroup>
						</template>
						<template v-else>

							<option 
								:value="option.value"
								:selected="option.selected"
								:disabled="option.disabled"
							>
								{{ option.label }}
							</option>

						</template>
					</template>
				</select>

				<span class="field-select__help-text" v-if="helptext">{{ helptext }}</span>
			</div>
		</div>
	`
})