/* global document */

const closest = require('closest');
const ready = require('../../js/utils/documentReady.js');
const $ = require('jquery');

ready(function(){

	const forms = document.querySelectorAll('form');
	forms.forEach(form => {

		// Объект для хранения файлов
		const Store = {
			files: {},
			inputs: {}
		};

		let fileItems = form.querySelectorAll( '.file-simple-js' );

		Array.prototype.forEach.call( fileItems, function( item ) {

			let itemName = item.getAttribute('name');
			// Для каждого блока fild-file создаем свой объект
			// с именем свойства = атрибуту name у инпута, 
			// и значением- массивом с файлами
			Store.files[itemName] = [];
			Store.inputs[itemName] = [];
			let parent = item.closest('.field-file');
			let itemsWrap = parent.querySelector('.field-file__items');
			let existingFiles = itemsWrap.querySelectorAll('.field-file__item-wrap');

			if (existingFiles.length > 0){

				existingFiles.forEach(file => {

					let thisFile = new File([''], file.querySelector('.field-file__item-name').innerText);
					Store.files[itemName].push(thisFile);
					Store.inputs[itemName].push(null);
				})
			}

			function addFiles(files, input) {
				// добавляем файлы в общую кучу
				Store.files[itemName] = Store.files[itemName].concat(files);
				Store.inputs[itemName] = Store.inputs[itemName].concat(input);
				parent.dispatchEvent(new CustomEvent('fileSetChanged',{
					detail: {}
				}))
			}

			// удалить файл из хранилища, например по индексу в массиве
			function removeFile(index) {
				// удаляем файл по индексу
				Store.files[itemName].splice(index, 1);
				Store.inputs[itemName].splice(index, 1);
				parent.dispatchEvent(new CustomEvent('fileSetChanged',{
					detail: {}
				}))
			}

			// Событие change, выбор файла
			item.addEventListener('change', (e) => {
				// если не выбрали файл и нажали отмену, то ничего не делать
				if (!e.target.files.length) {
					return;
				}	
				const files = Object.keys(e.target.files).map((i) => e.target.files[i]);
				addFiles(files, item.cloneNode(true));
				// очищаем input, т.к. файлы мы сохранили
				e.target.value = '';
			})

			// Обработчик удаления файла
			// на кнопке должен быть класс ".file-remove-js"
			document.addEventListener('click', (e)=>{
				let removeBtn = e.target.closest('.file-remove-js')

				if (!removeBtn) {
					return;
				}

				// let inputWrap = closest(removeBtn, '.field-file__input-wrap')
				// inputWrap.remove();
				let btnParent = removeBtn.closest('.field-file__item-wrap');
				let fileWraps = parent.querySelectorAll('.field-file__item-wrap')
				
				fileWraps.forEach((item, index) => {
					if (item === btnParent) {
						removeFile(index);
					}
				});
			})

			parent.addEventListener('fileSetChanged', (e) => {
				itemsWrap.innerHTML = '';
				let fileWrap = '';

				Store.files[itemName].forEach(item => {

					fileWrap += `
						<div class="field-file__item-wrap">
							<input type="hidden" value="${item.name}" name="ownfile[]">
							<div class="field-file__item-remove">
								<div class="remove  remove_bordered file-remove-js" onclick='removeFile(this)'></div>
							</div>
							<div class="field-file__item-name">
								${item.name}
							</div>
						</div>
					`;
				});
				itemsWrap.insertAdjacentHTML('afterbegin', fileWrap);

				let i = 0;
				Store.inputs[itemName].forEach(item => {

					if (item){

						item.removeAttribute('id');
						item.setAttribute('name', 'docs1_' + i);
						itemsWrap.querySelectorAll('.field-file__item-wrap')[i].insertAdjacentElement('afterbegin', item);
					}
					i++;
				});
			})
		});

	})

});
