const fieldFileItemWrap = {
	name: 'FieldFileItemWrap',
	props: ['file'],
	methods: {
		removeFileItem() {
			this.$emit('removeFileItem');
		}
	},
	template: `
		<div class="field-file__item-wrap">
				
			<div 	class="field-file__item-remove"
						@click="removeFileItem"
			>
				<div class="remove  remove_bordered"></div>
			</div>

			<div class="field-file__item-name">
				{{file.name}}
			</div>
			
		</div>
	`,
};

Vue.component('field-file',{
	props: {
		text: {
			type: String
		},
		attrs: {
			type: Object
		},
		files: {
			type: Array
		}
	},
	data: function () {
		return {
			localFiles: this.files.slice()
		}
	},
	methods: {
		onInputFileChange(e) {
			
			// если не выбрали файл и нажали отмену, то ничего не делать
			if (!e.target.files.length) {
				return;
			}	
			const files = Object.keys(e.target.files).map((i) => e.target.files[i]);
			this.addFiles(files);
			// очищаем input, т.к. файл мы сохранили
			e.target.value = '';
			
		},
		addFiles(files) {
			// Поправильному, прежде чем добавлять файлы нужно проверить не добавленны ли они ранее
			this.localFiles = this.localFiles.concat(files);
			// console.log(this.localFiles);
			this.$emit('filesSetChanges',files)
		},
		removeFile(index) {
			this.localFiles.splice(index, 1);
			
			this.$emit('filesSetChanges',this.localFiles)
		}
	},
	// watch: {
	// 	localFiles: ''
	// },
	components: {
		'field-file-item-wrap': fieldFileItemWrap
	},
	template: `
		<div class="field-file" ref="fieldFile">

			<field-file-item-wrap
				v-for="(file, index) in localFiles"
				:key="index"
				:file="file"
				@removeFileItem="removeFile(index)"
			>
			</field-file-item-wrap>

			<div class="field-file__btn">
				<label 	class="btn btn_secondary"
				>
					<span>{{ text }}</span>
					<input 	type="file"
									:name="attrs.name"
									:id="attrs.id"
									:multiple="attrs.multiple"
									class="field-file__input"
									@change="onInputFileChange"
					>
				</label>
			</div>

		</div>
	`
})