import axios from 'axios';

/* eslint-disable no-undef */
Vue.component('app-waste-utilisation-order', {
  data: function () {
    return {
      wasteRecords: [],
      record: {},
      recordEditIndex: null, // для указания на нужную строку при редактиравнии
      openForm: false,
      formOrder: null, //order формы, для вставки между строк
      address: [],
    }
  },
  computed: {},
  beforeMount() {
    // по умолчанию порядок расположения формы- в конце
    this.formOrder = this.wasteRecords.length;

    console.log('Содержимое localStorage: ',localStorage.getItem('lsWasteRecords'));

    // при загрузке страницы, если localStorage не пустой- вытаскиваем и
    // записываем в wasteRecords


    if (localStorage.getItem('lsWasteRecords')) {
      this.wasteRecords = JSON.parse(localStorage.getItem('lsWasteRecords'));
    }
    
    // Если масив с записями пустой сразу открываем форму
    //this.openForm = this.wasteRecords.length ? false : true;
    this.getOrderStatus();
  },
  methods: {
    // узнаем статус заявки 
    // если true - очищаем localStorage 
    getOrderStatus(){
      axios
        .get("/api/getOrderStatus/")
        .then(response => response.data)
        .then(options => {
          if (options["status"] == "true") {
            this.removeWasteAllRecords();
            this.openForm = true;
          }
      });
    },
    // запись данных в localStorage
    setLocalStorage() {
      // Предварительно очистим массивы wDocs с файлами
      // посколько они при преобразовании в JSON, 
      // а затем при боратной конвертации в объект теряются
      let tempWasteRecords = this.wasteRecords.map(item => {
        let obj = Object.assign({}, item)
        obj.wDocs = [];
        return obj;
      })
      
      let jsonWasteRecoors = JSON.stringify(tempWasteRecords);
      localStorage.setItem('lsWasteRecords', jsonWasteRecoors);
    },
    
    // Добавить запись в масив
    addNewWasteRecord(e) {
      this.wasteRecords.push(e);
      this.recordEditIndex = null;
      this.openForm = !this.openForm;
      this.setLocalStorage();
    },
    
    // Заменить запись в масиве
    replaceWasteRecord(e) {
      this.wasteRecords[this.recordEditIndex] = e;
      this.recordEditIndex = null;
      this.openForm = !this.openForm;
      this.setLocalStorage();
    },

    // Удалить запись из масива
    removeWasteRecord(index) {
      if (index !== undefined) {
        this.wasteRecords.splice(index,1);
      } else {
        this.wasteRecords.splice(this.recordEditIndex,1);
        this.recordEditIndex = null;
        this.openForm = !this.openForm;
      }
      this.setLocalStorage();
    },

    // Удалить все записи из массива
    removeWasteAllRecords(index) {
      if (index !== undefined) {
        this.wasteRecords.splice(index,10);
        //this.localStorage = null;
      } else {
        this.wasteRecords.splice(this.recordEditIndex,10);
        this.recordEditIndex = null;
        this.openForm = !this.openForm;
        //this.localStorage = null;
      }
      this.setLocalStorage();
    },

    // Открытие формы для создание новой записи.
    clickOnAddOnemore() {
      this.getAddressFromLast();
      this.formOrder = this.wasteRecords.length;
      this.record = {};
      this.openForm = !this.openForm;
    },

    // Открытие формы для редактирование существующей записи
    editWasteRecord(index) {
      this.recordEditIndex = index;
      this.formOrder = index;
      this.record = this.wasteRecords[index];
      this.openForm = !this.openForm;
    },

    // Отмена. Закрытие формы. Ничего не делаем
    canselWasteRecord() {
      this.recordEditIndex = null;
      this.openForm = !this.openForm;
    },

    getAddressFromLast() {
      for (let id in this.wasteRecords) {
        if ((this.wasteRecords[id]["wAddress"]) && (this.wasteRecords[id]["isAddress"]["value"])) {
          this.address = this.wasteRecords[id]["wAddress"];
        }
      }
    },
  },
  template: `
    <div>
      <div class="d-flex flex-column">
        <!-- Записи с заявками -->
        <app-waste-utilisation-order-record
          v-for="(record, index) in wasteRecords"
          v-show="index !== recordEditIndex"
          :class="openForm ? 'utilization-table__row_disabled': ''"
          :style="'order:' + index"
          :record="record"
          :key="index"
          @clickOnRecordRemoveBtn="removeWasteRecord(index)"
          @dblСlickOnRecord="editWasteRecord(index)"
        >
        </app-waste-utilisation-order-record>

          
        <!-- Форма заявки на утилизацию -->
        <app-waste-utilisation-order-form
          :record="record"
          :address="address"
          @clickOnAddToApplicationFormBtn="addNewWasteRecord"
          @clickOnSaveFormBtn="replaceWasteRecord"
          @clickOnCanselFormBtn="canselWasteRecord"
          @clickOnDeleteFormBtn="removeWasteRecord"
          :style="'order:' + formOrder"
          v-if="openForm"
        >
        </app-waste-utilisation-order-form>

      </div>
        

      <!-- Кнопка Добавить ещё один вид отхода -->
      <div v-if="!openForm" class="block_yellow-t">
        <div class="row">
          <div class="offset-lg-2 col-lg-8">
            <a  href="/" 
                class="btn btn_primary"                
                v-on:click.prevent="clickOnAddOnemore">
              <span>+ Добавить ещё один вид отхода</span>
            </a>
          </div>



        </div>
      </div>

      <!-- utilization-total -->
      
      
      <utilization-total
        v-if="!(wasteRecords == '')"
        :record="Object.assign({},wasteRecords)"
        @RemoveAll="removeWasteAllRecords(index)">
      </utilization-total>

    </div>
  `
})