/* eslint-disable no-console */
// eslint-disable-next-line no-undef
import axios from 'axios';
import $ from 'jquery';

Vue.component('app-waste-utilisation-order-form', {
	props: {
		record: {
			type: Object
		},
		address: {
			type: Object
		},
		docs: {
			type: Object
		}
	},
	data: function () {
		return {
			//Select & upload file setings
			wGroupSelect: {
				title: 'Группа отходов',
				attrs: {
					name: 'waste-group',
					id: 'waste-group',
					required: true
				},
				options: [],
				settings: {
					searchEnabled: true,
					shouldSort: false,
	  	    		noChoicesText: 'Пусто',
					noResultsText: 'Ничего не найдено',
					searchResultLimit: '5',
					maxItemCount: '40',
						  
				},
				helptext: ''
			},
			wMainGroupSelect: {
				title: 'Вид отходов',
				attrs: {
					name: 'waste-group',
					id: 'waste-group',
					required: false
				},
				options: [],
				settings: {
					searchEnabled: true,
					shouldSort: false,
					noChoicesText: 'Пусто',
					noResultsText: 'Ничего не найдено',
				},
				helptext: ''
			},
			wGroupLampSelect: {
				title: 'Маркировка',
				attrs: {
					name: 'waste-group-lamp',
					id: 'waste-group-lamp',
					required: true
				},
				options: [],
				settings: {
					searchEnabled: true,
					shouldSort: false,
					noChoicesText: 'Пусто',
					noResultsText: 'Ничего не найдено',
				},
				helptext: ''
			},
			wDangerClassSelect: {
				title: 'Класс опасности',
				attrs: {
					name: 'danger-class',
					id: 'danger-class',
					required: true
				},
				options: [],
				settings: {
					searchEnabled: false,
					shouldSort: false,
					noChoicesText: 'Пусто',
					noResultsText: 'Ничего не найдено',
				},
				helptext: ''
			},
			wUnitSelect: {
				title: 'Ед. изм.',
				attrs: {
					name: 'waste-units',
					id: 'waste-units',
					required: true
				},
				options: [],
				settings: {
					searchEnabled: false,
					shouldSort: false,
					noChoicesText: 'Пусто',
					noResultsText: 'Ничего не найдено',
				},
				helptext: ''
			},
			fieldFileAttrs: {
				text: 'Прикрепить документ',
				attrs: {
					id: 'docs-upload',
					name: 'docs-upload',
					multiple: true
				}
			},
			// Current mode (editing record or create new record)
			isEditing: !this.objEmty(this.record),
			// Local form state
			localRecord: {},
			initValue: {
				value: '0'
			},
			ShowDrop: 'false',
		}
	},
	created() {

		this.localRecord = this.isEditing ? Object.assign({},this.record) : {
			wType: {
				name: 'communal',
				caption: 'Сбор коммунальных отходов',
			},
			wMainGroup: {},
			wGroup: {},
			wDangerClass: {},
			wFKKO: {
				code: '',
				description: ''
			},
			wAmount: '',
			wUnit: {},
			wDocs: [],
			wAddress: {
				region: {
					id: null,
					name: ''
				},
				city: {
					id: null,
					name: ''
				},
				street: {
					id: null,
					name: ''
				},
				building: {
					id: null,
					name: ''
				},
				extra: ''
			},
			wCost: {
				value: '0',
			},
			isTransport: {
				value: true,
			},
			isAddress: {
				value: false,
			},
			wTransportCost: {
				value: '0',
			},
			wClear: {
				value: '1',
			},
		};

		if (this.address.city) {
			this.localRecord.isAddress.value = true;
			this.localRecord.wAddress = this.address;

		}
	},
	mounted() {
		if (this.isEditing) {
			//console.log("Режим редактирования")
		} else {
			//console.log("Режим создания новой записи")
		}

		// Подгружаем группы отходов

		this.wasteMainGroupsLoad();
		this.wasteGroupsLoad();
		this.fiasInit();
	},
	computed: {

		
		wasteGroupUrl() {
			//https://r52.ru/
			return '/api/type/' + this.localRecord.wType.name + (this.localRecord.wMainGroup.value ? "/" + this.localRecord.wMainGroup.value : "/");
		},
		wasteMainGroupUrl(){
			return '/api/mainType/' + this.localRecord.wType.name
		},
		// Открываем кнопку "сохранить"
		formFilledRight() {
			return 	(!this.objEmty(this.localRecord.wGroup)) && 
							(this.localRecord.wAmount !== '') && 
							(this.localRecord.wAddress.region.name !== '') &&
							(this.localRecord.wAddress.city.name !== '') &&
							(this.localRecord.wAddress.street.name !== '') &&
							(this.localRecord.wAddress.building.name !== '');
		}
	},
	methods: {

		// Вводи кода отхода вручную

		codeUp(){

			this.localRecord.wGroup = {};

			if ((this.localRecord.wFKKO.code).length > 3) {

				for (let i in this.wGroupSelect.options) {
					if (((this.wGroupSelect.options[i]["label"]).includes(this.localRecord.wFKKO.code)) || 
							((this.wGroupSelect.options[i]["value"]).includes(this.localRecord.wFKKO.code)) || 
							((this.localRecord.wFKKO.code).includes(this.wGroupSelect.options[i]["value"])) ||
							((this.localRecord.wFKKO.code).includes(this.wGroupSelect.options[i]["label"]))) {

									this.localRecord.wGroup = {
										"value": this.wGroupSelect.options[i]["label"],
										"caption": this.wGroupSelect.options[i]["value"]
									};

									if ((this.localRecord.wFKKO.code).length == 11) {
										this.localRecorf.wDangerClass = {
											"value": (this.localRecord.wFKKO.code).slice(-1),
											"caption": (this.localRecord.wFKKO.code).slice(-1)
										};
									}
									
					}

				}
			}
			

		},

		objEmty(obj) {
			return Object.keys(obj).length === 0
		},

		// КЛАДР
		fiasInit() {

			let $this = this;
			$.fias.token = 'tiyhha6YHyNi6EfeyfrRrdrDQkyehf59';
			$.fias.url = 'https://kladr-api.com/api.php';

			let $container = $(this.$refs.address);

			let $region = $container.find('[name="region"]');
			let $city = $container.find('[name="city"]');
			let $street = $container.find('[name="street"]');
			let $building = $container.find('[name="building"]');

			if (this.isEditing) {
				$region.val(this.localRecord.wAddress.region.name);
				$city.val(this.localRecord.wAddress.city.name);
				$street.val(this.localRecord.wAddress.street.name);
				$building.val(this.localRecord.wAddress.building.name);
			}

			if (this.localRecord.isAddress.value) {
				$region.val(this.localRecord.wAddress.region.name);
				$city.val(this.localRecord.wAddress.city.name);
				$street.val(this.localRecord.wAddress.street.name);
				$building.val(this.localRecord.wAddress.building.name);
			}
			
			$.fias.setDefault({
				parentInput: $container,
				verify: true,
				select: function (obj) {
					//console.log('Select')
					//console.log(obj)
					// var $input = $(this);
					// $input.parents('label').removeClass('field-text_error');
				},
				checkBefore: function () {
					// console.log('checkBefore');
					let $input = $(this);
					if (!$.trim($input.val())) {
						$input.parents('label').removeClass('field-text_error');
						return false;
					}
				},
				check: function (obj) {
					
					// console.log('Cheked');
					// console.log(obj)
					let $input = $(this);

					if (obj) {
						$input.parents('label').removeClass('field-text_error');
					}
					else {
						$input.parents('label').addClass('field-text_error');
					}
				},
				change: function (obj) {
					// console.log('change');
					// console.log(obj)
					let $input = $(this);

					if (obj) {
						if (obj.parents) {
							$.fias.setValues(obj.parents, $container);
						}

						$this.localRecord.wAddress[obj.contentType].id = obj.id;
						$this.localRecord.wAddress[obj.contentType].name = obj.name;

						$input.parents('label').removeClass('field-text_error');

					} else {
						$this.localRecord.wAddress[$input.attr('name')].id = null;
						$this.localRecord.wAddress[$input.attr('name')].name = '';

						if ($.trim($input.val())) {
							$input.parents('label').addClass('field-text_error');
						}
					}
				}
				
			});					
			
			$region.fias('type', $.fias.type.region);
			$city.fias('type', $.fias.type.city);
			$street.fias('type', $.fias.type.street);
			$building.fias('type', $.fias.type.building);

			$city.fias('withParents', true);
			$street.fias('withParents', true);

			// Отключаем проверку введённых данных для строений
			// $building.fias('verify', false);
		},

		// Подгрузка селектора гнлавных групп отходов 

		wasteMainGroupsLoad(){
			axios
			.get(this.wasteMainGroupUrl)
				.then(response => response.data)
				.then(options => {

					// новый бланк/старый 
					this.initValue.value = !this.isEditing ? this.initValue.value : this.localRecord.wMainGroup.value;
					let groupsArr = [];

					for(var k in options){
						if (options[k]["group"]) {
							groupsArr.push(options[k]["group"]);
						}
					}
					this.$set(this.wMainGroupSelect, 'options', groupsArr);
					this.dateFromGroup();
				})
		},

		// Подгрузка селектора группы отходов 
		wasteGroupsLoad() {
			axios
				.get(this.wasteGroupUrl)
				.then(response => response.data)
				.then(options => {
					this.initValue.value = 	!this.isEditing ? 
																	this.initValue.value :
																	this.localRecord.wGroup.value;
					let groupsArr = [];

					for(var k in options){
						if (options[k]["group"]) {
							groupsArr.push(options[k]["group"]);
						}
					}
					this.$set(this.wGroupSelect, 'options', groupsArr);
					this.dateFromGroup();
				})
		},
		dateFromMainGroup() {
			this.wasteGroupsLoad();
		},
		dateFromGroup() {
				axios
				.get(this.wasteGroupUrl)
				.then(response => response.data)
				.then(options => {
					this.initValue.value = !this.isEditing ? this.initValue.value : this.localRecord.wGroup.value;
					for(var k in options){
						if (this.localRecord.wGroup["value"] !== undefined){
								if (options[k]["group"]["value"] == this.localRecord.wGroup["value"]){
									this.$set(this.wDangerClassSelect, 'options', options[k]["class"]);	
									this.$set(this.wUnitSelect, 'options', options[k]["price_units"]);
							}
						} else {
							this.$set(this.wDangerClassSelect, 'options', {});	
							this.$set(this.wUnitSelect, 'options', {});
						}
						
					}												
			})
		},
		priceFromSelect() {
			axios
				.get(this.wasteGroupUrl)
				.then(response => response.data)
				.then(options => {
					this.initValue.value = 	!this.isEditing ? 
																	this.initValue.value :
																	this.localRecord.wGroup.value;
					
					for(var k in options){
							if (options[k]["group"]["value"] == this.localRecord.wGroup["value"]){
									this.$set(this.wDangerClassSelect, 'options', options[k]["class"]);	
									this.$set(this.wUnitSelect, 'options', options[k]["price_units"]);	

									options[k]["price_units"].forEach(element => {
											if (element["value"] == this.localRecord.wUnit["value"]){
												this.localRecord.wCost["value"] = parseFloat(this.localRecord.wAmount * element["price"]).toFixed(2);
											}
									});
							}
						}											
				}),
				this.delivCost();
		},

		isTransport() {
			if (this.localRecord.isTransport.value) {
				this.localRecord.isTransport.value = false;
				this.localRecord.wTransportCost.value = "0";
			} else {
				this.localRecord.isTransport.value = true;
				this.delivCost();
			}
		},

		isAddress() {
			if (this.localRecord.isAddress.value) {
				this.localRecord.isAddress.value = false;
			} else {
				this.localRecord.isAddress.value = true;
			}
		},

		delivCost(){

			if (this.localRecord.isTransport.value) {

				let address = (this.localRecord.wAddress.region.name ? this.localRecord.wAddress.region.name + "," : "") + 
				(this.localRecord.wAddress.city.name ? this.localRecord.wAddress.city.name : "") + 
				(this.localRecord.wAddress.street.name ? ',' + this.localRecord.wAddress.street.name : "") +
				(this.localRecord.wAddress.building.name ? ',' + this.localRecord.wAddress.building.name : "");


				axios({
					method:"GET",
					params: {
						address: address,
						unit: this.localRecord.wUnit["caption"],
						amount: this.localRecord.wAmount,
						group: this.localRecord.wGroup["value"]
						},
					url: "/api/transport/getPrice/"
				}).then(response => response.data)
					.then(options => {
						this.localRecord.wTransportCost["value"] = parseFloat(options["price"]).toFixed(2);
				});
				
			}
		},
		onFilterChange(e) {

			this.localRecord.wType = e;


			this.localRecord.wMainGroup = {}
			this.localRecord.wGroup = {};
			this.localRecord.wDangerClass = {};
			this.localRecord.wUnit = {};
			this.localRecord.wFKKO = {};
			this.localRecord.wAmount = "";
			
			this.wasteMainGroupsLoad();
			this.wasteGroupsLoad();
		},
		
		clickOnAddToApplicationFormBtn() {
			this.$emit('clickOnAddToApplicationFormBtn', this.localRecord)
		},

		clickOnSaveFormBtn() {
			this.$emit('clickOnSaveFormBtn', this.localRecord)
		},

		clickOnCanselFormBtn() {
			this.$emit('clickOnCanselFormBtn')
		},

		clickOnDeleteFormBtn() {
			this.$emit('clickOnDeleteFormBtn')
		},
		// При изменении списка файлов
		updateDocs(e) {
			this.localRecord.wDocs = this.$children["4"].localFiles;
		},

		// открываем/закрываем выпадашку селектора 
		changeShowDrop() {
			if (this.ShowDrop) {
				this.ShowDrop = false;
			} else {
				this.ShowDrop = true;
			}
		}
	},
	template: `
	<div class="row utilization-table__row" ref="orderForm">
		<!-- Filter -->
		<div class="col-lg-2">
			<waste-filter 
				:value="localRecord.wType.name"
				@change="onFilterChange"
			>
			</waste-filter>
		</div>

		<!-- Debug --->
		<!--

			<div class="debug"
				 style="position: absolute; right: -270px;top: 500px; background-color:#fff; z-index:1000; width: 400px; height: 1000px; padding: 10px; border: 1px solid #999;">
				<pre>
					{{ ShowDrop }}
				</pre>
			</div>
		--!>
		<!-- end Debug -->

		<!-- Form -->
		<div class="col-lg-8">
			<div class="block_bg-color-white block_green block_p-40">
				<h2>{{ localRecord.wType.caption }}</h2>
				<form class="form"></form>

					<fieldset class="form__fieldset">
						<legend class="form__legend">Вид отхода</legend>

						<!-- not lamp -->

						<div class="row"
								 v-if="localRecord.wType['name'] != 'lamps'">

							<div class="col-md-12">
								<div class="block_orange-b">
									<!-- Вид отхода. Список -->
									<field-select 	
										v-bind="wMainGroupSelect"
										:init="localRecord.wMainGroup"
										@change="localRecord.wMainGroup = $event"
										@change="dateFromMainGroup"
									>
									</field-select>
								</div>
							</div>

							<div class="col-md-9"
									 v-if="localRecord.wType['name'] != 'communal'">
								<div class="block_orange-b">
									<!-- Вид отхода. Список -->
									<field-select 	
										v-bind="wGroupSelect"
										:init="localRecord.wGroup"
										@change="localRecord.wGroup = $event"
										@change="dateFromGroup"
									>
									</field-select>
								</div>
							</div>

							<div class="col-md-12"
								 v-if="localRecord.wType['name'] == 'communal'">
								<div class="block_orange-b">
									<!-- Вид отхода. Список -->

									<field-select 	
										v-bind="wGroupSelect"
										:init="localRecord.wGroup"
										@change="localRecord.wGroup = $event"
										@change="dateFromGroup"
										:showDropProp="this.ShowDrop"
									>
									</field-select>
								</div>
							</div>

							<div class="col-7 col-sm-4 col-md-3 col-lg-4 col-xl-3"
									 v-if="localRecord.wType['name'] != 'communal'">
								<div class="block_orange-b">
									<field-select 	
										v-bind="wDangerClassSelect"
										:init="localRecord.wDangerClass"
										@change="localRecord.wDangerClass = $event"
										>
									</field-select>

								</div>
							</div>

						</div>


						<info-block v-if="localRecord.wType['name'] != 'lamps'">
							Список содержит часто спрашиваемые виды отходов. Если Вы не нашли необходимый вид отхода, введите наименование отхода 
							<a href="javascript:void(0)" @click="changeShowDrop"> самостоятельно</a>
						</info-block>

						<!-- /if not lamp -->

						<!-- if lamp --> 

						<div class="row"
								 v-if="localRecord.wType['name'] == 'lamps'">

							<div class="col-md-12">
								<div class="block_orange-b">
									<!-- Вид отхода. Список -->
									<field-select 	
										v-bind="wGroupSelect"
										:title="wGroupLampSelect.title"
										:init="localRecord.wGroup"
										@change="localRecord.wGroup = $event"
										@change="dateFromGroup"
									>
									</field-select>
								</div>
							</div>

						</div>

						<div class="block_cyan-b"
								 v-if="localRecord.wType['name'] == 'lamps'">
							<div class="row">
								<div class="col-6 col-sm-6">
									<label class="field-text">
										<span class="field-text__name">Длина</span>
										<span class="field-text__input-wrap">
											<input 	
												type="text" 
												placeholder="Длина" 
												class="field-text__input"
												:disabled="false"
											>
										</span>
									</label>
								</div>
								<div class="col-6 col-sm-6">
									<label class="field-text">
										<span class="field-text__name">Диметр</span>
										<span class="field-text__input-wrap">
											<input 
												type="text" 
												placeholder="Диметр" 
												class="field-text__input"
												:disabled="false"
											>
										</span>
									</label>
								</div>
							</div>
						</div>

						<info-block v-if="localRecord.wType['name'] == 'lamps'">
							Список содержит часто спрашиваемые виды отходов. Если Вы не нашли необходимую маркировку лампы, введите длину и диаметр <a href=""> самостоятельно</a>
						</info-block>

						<!-- /if lamp -->

					</fieldset>

					<div class="hr"></div>

					<fieldset class="form__fieldset">
						<legend class="form__legend">Количество отходов</legend>

						<div class="row">
							<div class="col-8 col-sm-6">

								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">
											Количество отходов <span style="color: red;">*</span>
										</span>
										<span class="field-text__input-wrap">
											<input 	
												type="text" 
												placeholder="Количество" 
												class="field-text__input"
												v-model.number="localRecord.wAmount"
												@change="priceFromSelect"
											>
										</span>
									</label>
								</div>

							</div>
							<div class="col-4 col-sm-2">
								<div class="block_orange-b">

									<field-select
										v-bind="wUnitSelect"
										:init="localRecord.wUnit"
										@change="localRecord.wUnit = $event"
										@change="priceFromSelect"
									>
									</field-select>

								</div>
							</div>
						</div>

						<field-file 
							:text="fieldFileAttrs.text"
							:attrs="fieldFileAttrs.attrs"
							:files="localRecord.wDocs"
							@filesSetChanges="updateDocs"
						>
						</field-file>

						<info-block>
							Вы можете загрузить файлы в формате TXT, DOC, XML, PDF, JPG, PNG, BMP, GIF размером не более 5 Мб
						</info-block>

					</fieldset>

					<div class="hr"></div>

					<fieldset class="form__fieldset form__fieldset_address" ref="address">
						<legend class="form__legend">Адрес объекта</legend>

						<div class="block_orange-b">
							<div class="row">
								<div class="col-sm-6">

									<label class="field-text">
										<span class="field-text__name">Область</span>
										<span class="field-text__input-wrap">
											<input 
												name="region"	
												type="text" 
												placeholder="Область" 
												class="field-text__input"
												@change="delivCost"
											>
										</span>
									</label>

								</div>
							</div>
						</div>

						<div class="block_orange-b">
							<div class="row">
								<div class="col-sm-6">

									<label class="field-text">
										<span class="field-text__name">Населённый пункт <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 
												name="city"
												type="text" 
												placeholder="Населённый пункт" 
												class="field-text__input"
												:disabled="false"
												@change="delivCost"
											>
										</span>
									</label>

								</div>
							</div>
						</div>

						<div class="block_orange-b">
							<div class="row">
								<div class="col-8 col-sm-6">
									<label class="field-text">
										<span class="field-text__name">Улица <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	
												name="street"
												type="text" 
												placeholder="Улица" 
												class="field-text__input"
												:disabled="false"
												@change="delivCost"
											>
										</span>
									</label>
								</div>
								<div class="col-4 col-sm-3">
									<label class="field-text">
										<span class="field-text__name">Дом <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 
												name="building"
												type="text" 
												placeholder="Дом" 
												class="field-text__input"
												:disabled="false"
												@change="delivCost"
											>
										</span>
									</label>
								</div>
							</div>
						</div>

						<div class="block_yellow-b">
							<label class="field-text">
								<span class="field-text__name">Дополнительная информация об адресе объекта</span>
								<span class="field-text__input-wrap">
									<input	
										type="text" 
										placeholder="Дополнительная информация" 
										class="field-text__input"
										v-model="localRecord.wAddress.extra"
										:disabled="false"
									>
								</span>
							</label>
						</div>

						<div class="block_yellow-b">
							<div class="field-checkbox">
								<div class="field-checkbox__input-wrap">
									<label class="field-checkbox__name">
										<input 
											type="checkbox" 
											name="check0" 
											class="field-checkbox__input"
											:checked="localRecord.isAddress.value"
											@click="isAddress">
										<span class="field-checkbox__name-text">Использовать этот адрес для всех новых пунктов заявки</span>
									</label>
								</div>
							</div>
						</div>

						<div class="block_yellow-b">
							<div class="block_bg-color-gray block_p-20">
								<div class="field-checkbox">
									<div class="field-checkbox__input-wrap">
										<label class="field-checkbox__name">
											<input 
												type="checkbox" 
												name="check1" 
												class="field-checkbox__input"
												:checked="localRecord.isTransport.value"
												@click="isTransport"
											>
											<span class="field-checkbox__name-text">
													<span style="color: red;">Рассчитать утилизацию отхода с учётом транспортировки</span>
											</span>
										</label>
									</div>
								</div>
							</div>
						</div>
						<div id="tooltip" class="tooltip" style="display: none;">
							<b></b><span></span>
						</div>
					</fieldset>

					<div class="field-actions" v-if="isEditing">

						<div class="field-actions__text">
							<span style="color: red;">*</span> — поля, обязательные для заполнения
						</div>

						<div class="row">
							<div class="col-md flex-grow-0 mb-20 mb-md-0">
								<input 
												value="Сохранить" 
												type="button" 
												class="btn btn_primary btn_sm-full"
												@click="clickOnSaveFormBtn"
								>
							</div>

							<div class="col-md flex-grow-0 mb-20 mb-md-0">
								<input 
												value="Отменить" 
												type="button" 
												class="btn btn_secondary btn_sm-full"
												@click="clickOnCanselFormBtn"
								>
							</div>

							<div class="col-md text-right mb-20 mb-md-0">
								<input 
												value="Удалить из заявки" 
												type="button" 
												class="btn btn_secondary btn_sm-full"
												@click="clickOnDeleteFormBtn"
								>
							</div>
						</div>
					</div>
					
					<div class="field-actions" v-else>

						<div class="field-actions__text">
							<span style="color: red;">*</span> — поля, обязательные для заполнения
						</div>

						<div class="row">

							<div class="col-sm flex-grow-0 mb-20 mb-sm-0">
								<input 
									value="Добавить в заявку" 
									type="button" 
									class="btn  btn_primary btn_xs-full"
									:disabled="!formFilledRight"
									@click="clickOnAddToApplicationFormBtn"
								>
							</div>

							<div class="col-sm flex-grow-0 mb-20 mb-sm-0">
								<input 
									value="Отменить"
									type="button"
									class="btn btn_secondary btn_xs-full"
									@click="clickOnCanselFormBtn"
								>
							</div>

						</div>
					</div>

				</form>
			</div>
		</div>
	</div>

	
	`
})