Vue.component('app-registration', {
	props: {
		reg_info_from: {
			type: String
		}
	},
	data: function () {
		return {
			persons: {
				juridical: 'Юридическое лицо',
				natural: 'Физическое лицо',
			},
			activeType: 'juridical',
			reg_info_to: this.reg_info_from,
		}
	},
	template: `
		<div class="row">
			<div class="offset-lg-1 col-lg-10 offset-xl-2 col-xl-8">
	
				<div class="order-registration__user-types">

					<a 	href="" 
							:class="['order-registration__user-type-item', (activeType == key) ? 'active' : '']"
							v-for="(name, key, index) in persons"
							:key="index"
							@click.prevent="activeType = key"
					>
						<span>{{ name }}</span>
					</a>
					
				</div>

				<app-registration-form
					:personType="activeType"
					:personRegTypeProp="reg_info_to"
				></app-registration-form>

			</div>
		</div>
	`
})