/* eslint-disable no-undef */
import { ValidationProvider, extend } from 'vee-validate';
import { required, email } from 'vee-validate/dist/rules';
import $ from 'jquery';
import axios from 'axios';

import 'vue-the-mask'

extend('required', required);
extend('email', email);

Vue.component('ValidationProvider', ValidationProvider);

Vue.component('app-registration-form', {
	props: {
		personRegTypeProp: {
			type: String
		},
		personType: {
			type: String
		},
	},
	data: function () {
		return {

			wGroupSelect: {
				title: 'Вид транспорта',
				attrs: {
					name: 'trans-types',
					id: 'trans-types',
					required: true
				},
				options: [],
				settings: {
					searchEnabled: true,
					shouldSort: false,
					noChoicesText: 'Пусто',
					noResultsText: 'Ничего не найдено',
				},
				helptext: ''
			},
			wUnitsSelect: {
				title: 'Ед. Изм.',
				attrs: {
					name: 'units',
					id: 'units',
					required: true
				},
				options: [],
				settings: {
					searchEnabled: false,
					shouldSort: false,
			noChoicesText: 'Пусто',
			noResultsText: 'Ничего не найдено',
				},
				helptext: ''
			},
			wUnitAmounts: [{}],

			personRegType: this.personRegTypeProp,
			buttonRegTxt: this.txtForRegButton(),
			stages: this.typeOfStages(),
			fieldsVal: {
				juridical: {
					companyName: '',
					companyInn: '',
					companyKpp: '',
					companyJurAddress: '',

					companyBankName: '',
					companyBankAcount: '',
					companyBankCorrAcount: '',
					companyBankBik: '',

					companyChiefPost: '',
					companyChiefFullname: '',
					companyChiefActingUnder : '',

					companyContactPost: '',
					companyContactSecondName: '',
					companyContactFirstName: '',
					companyContactLastName: '',
					companyContactEmail: '',
					companyContactPhone: '',

					companyExtraDate: '',
					companyExtraComment: '',

					companyAuthLogin: '',
					companyAuthPass: '',
					companyAuthPassRepeat: '',

					companyTrans: '',
					companyGovNum: '',
					companyTransportCostPerKm: '',
				},
				natural: {
					personInfoLastname: '',
					personInfoFirstname: '',
					personInfoPatronymic: '',
					personInfoEmail: '',
					personInfoPhone: '',

					personPassportSeries: '',
					personPassportNumber: '',
					personPassportIssuedBy: '',
					personPassportIssuedDate: '',
					personPassportDepartmentCode: '',

					personAddressRegion: '',
					personAddressCity: '',
					personAddressStreet: '',
					personAddressBuilding: '',

					personExtraDate: '',
					personExtraComment: '',

					personAuthLogin: '',
					personAuthPass: '',
					personAuthPassRepeat: '',

					personTrans: '',
					personGovNum: '',
					personTransportCostPerKm: '',
				}
			},
			currentPT: this.personType, //текущий тип клиента
			currentStage: 0,
		}
	},
	created() {
		this.localRecord =  {
			wGroup: {},
			wAddress: {
				region: {
					id: null,
					name: ''
				}
			},
		};

		this.transportGroupLoad();
	},
	computed: {

		firstStage() {
			return this.currentStage === 0
		},
		lastestStage() {
			if (this.currentPT == "juridical") {
				return this.currentStage === 2
			} else if (this.currentPT == "natural") {
				return this.currentStage === 1
			}
		},
		lastStage() {
			return this.currentStage >= this.stages[this.currentPT].length - 1
		},

		is_executor(){
			if (this.personRegType == "executor") {
				return true;
			} else {
				return false;
			}
		},

		nextpage() {

			if (this.currentPT == "juridical") {
				if (this.currentStage == 0) {

					if (
						(this.validateInn(this.fieldsVal.juridical.companyInn)) &&
						(this.validateKpp(this.fieldsVal.juridical.companyKpp)) &&
						(this.fieldsVal.juridical.companyJurAddress !== "")
					) { 
						return false; 
					}

				} else if (this.currentStage == 1) {
					if (
						(this.valdateName(this.fieldsVal.juridical.companyChiefFullname)) &&
						(this.valdateName(this.fieldsVal.juridical.companyChiefActingUnder)) &&

						(this.valdateName(this.fieldsVal.juridical.companyContactSecondName)) && 
						(this.valdateName(this.fieldsVal.juridical.companyContactFirstName)) && 
						(this.valdateName(this.fieldsVal.juridical.companyContactLastName)) && 

						(this.valdateMail(this.fieldsVal.juridical.companyContactEmail)) && 
						(this.valdatePhone(this.fieldsVal.juridical.companyContactPhone))
						) {

						return false;
					}
				} 
			} else if (this.currentPT == "natural") {
				if (this.currentStage == 0) {

					if (
						(this.valdateName(this.fieldsVal.natural.personInfoLastname)) &&
						(this.valdateName(this.fieldsVal.natural.personInfoFirstname)) &&
						(this.valdateName(this.fieldsVal.natural.personInfoPatronymic)) &&

						(this.valdateMail(this.fieldsVal.natural.personInfoEmail)) &&
						(this.valdatePhone(this.fieldsVal.natural.personInfoPhone)) &&

						(this.valdatePassSer(this.fieldsVal.natural.personPassportSeries)) &&
						(this.valdatePassNum(this.fieldsVal.natural.personPassportNumber)) &&
						(this.valdateName(this.fieldsVal.natural.personPassportIssuedBy)) &&
						(this.valdatePassDate(this.fieldsVal.natural.personPassportIssuedDate)) &&
						(this.valdateName(this.fieldsVal.natural.personPassportDepartmentCode))

					) { 
						return false; 
					}
				} 
			}

			return true;
		},

		formFilledRight() {
			
			if (this.currentPT == "juridical") { 
				if (

					(this.validateInn(this.fieldsVal.juridical.companyInn)) &&
					(this.validateKpp(this.fieldsVal.juridical.companyKpp)) &&
					(this.fieldsVal.juridical.companyJurAddress !== "") && 
					(this.valdateName(this.fieldsVal.juridical.companyChiefFullname)) &&
					(this.valdateName(this.fieldsVal.juridical.companyChiefActingUnder)) &&

					(this.valdateName(this.fieldsVal.juridical.companyContactSecondName)) && 
					(this.valdateName(this.fieldsVal.juridical.companyContactFirstName)) && 
					(this.valdateName(this.fieldsVal.juridical.companyContactLastName)) && 

					(this.valdateMail(this.fieldsVal.juridical.companyContactEmail)) && 
					(this.valdatePhone(this.fieldsVal.juridical.companyContactPhone))

				) {
					if (this.personRegType !== "executor") {
						if (
							(this.valdateLogin(this.fieldsVal.juridical.companyAuthLogin)) &&
							(this.valdatePass(this.fieldsVal.juridical.companyAuthPass, this.fieldsVal.juridical.companyAuthPassRepeat))) {
							return true;
						}
					} else {
						if (
							(this.valdateName(this.fieldsVal.juridical.companyTrans)) &&
							(this.valdateName(this.fieldsVal.juridical.companyGovNum)) && 
							(this.localRecord.wAddress.region.name !== '') && 
							(this.fieldsVal.juridical.companyTransportCostPerKm !== '')
						) {
							return true;
						}
					}
				}

			} else if (this.currentPT == "natural") {
				if (

					(this.valdateName(this.fieldsVal.natural.personInfoLastname)) &&
					(this.valdateName(this.fieldsVal.natural.personInfoFirstname)) &&
					(this.valdateName(this.fieldsVal.natural.personInfoPatronymic)) &&

					(this.valdateMail(this.fieldsVal.natural.personInfoEmail)) &&
					(this.valdatePhone(this.fieldsVal.natural.personInfoPhone)) &&

					(this.valdatePassSer(this.fieldsVal.natural.personPassportSeries)) &&
					(this.valdatePassNum(this.fieldsVal.natural.personPassportNumber)) &&
					(this.valdateName(this.fieldsVal.natural.personPassportIssuedBy)) &&
					(this.valdatePassDate(this.fieldsVal.natural.personPassportIssuedDate)) &&
					(this.valdateName(this.fieldsVal.natural.personPassportDepartmentCode)) 
				) { 
					if (this.personRegType !== "executor") {
						if (
							(this.valdateLogin(this.fieldsVal.natural.personAuthLogin)) &&
							(this.valdatePass(this.fieldsVal.natural.personAuthPass, this.fieldsVal.natural.personAuthPassRepeat))
						) {
							return true;
						}
					} else {
						if (
							//(this.localRecord.wGroup != {}) && 
							(this.valdateName(this.fieldsVal.natural.personTrans)) &&
							(this.valdateName(this.fieldsVal.natural.personGovNum)) && 
							(this.localRecord.wAddress.region.name !== '') && 
							(this.fieldsVal.natural.personTransportCostPerKm != '') 
							//(this.wUnitAmounts != [{}]) 
						) {
							return true;
						}
					}
				}
			}

			return false;

		},
	},
	watch: {
		personType() {

			this.currentPT = this.personType;
			this.currentStage = 0
		},
		fieldsVal: {
			handler() {
				// console.log('Field changes')
			},
			deep: true
		}
	},
	methods: {

		selectTrans(e){
			this.localRecord.wGroup = e;
			this.transportUnitsLoad();
		},
		addUnit(){
			//alert(this.wUnitsSelect.options.length);
			this.wUnitAmounts.push({});
		},
		addСapacity(index,e){
			this.wUnitAmounts[index].value = e.value;
			this.wUnitAmounts[index].label = e.caption;
			//alert(JSON.stringify(e));
		},
		//https://r52.ru
		transportGroupUrl(){
			return '/api/transport/getTypes/';
		},
		transportUnitsUrl(id){
			return '/api/transport/getUnits/' + id;
		},
		transportGroupLoad(){
			axios
			.get(this.transportGroupUrl())
			.then(response => response.data)
			.then(options => {
				this.wGroupSelect.options = options;
			})
		},

		transportUnitsLoad(){
			axios
			.get(this.transportUnitsUrl(this.localRecord.wGroup.value))
			.then(response => response.data)
			.then(options => {
				this.$set(this.wUnitsSelect, 'options', options);
				this.wUnitAmounts = [{}];
				//this.wUnitAmounts[0] = options[0];
			})
		},

		fiasInit() {
			let $this = this;
			$.fias.token = 'tiyhha6YHyNi6EfeyfrRrdrDQkyehf59';
			$.fias.url = 'https://kladr-api.com/api.php';
			let $container = $(this.$refs.address);
			let $region = $container.find('[name="region"]');
			$.fias.setDefault({
				parentInput: $container,
				verify: true,
				select: function (obj) {},
				checkBefore: function () {
					let $input = $(this);
					if (!$.trim($input.val())) {
						$input.parents('label').removeClass('field-text_error');
						return false;
					}
				},
				check: function (obj) {
					let $input = $(this);
					if (obj) {
						$input.parents('label').removeClass('field-text_error');
					}
					else {
						$input.parents('label').addClass('field-text_error');
					}
				},
				change: function (obj) {
					let $input = $(this);
					if (obj) {
						if (obj.parents) {
							$.fias.setValues(obj.parents, $container);
						}
						$this.localRecord.wAddress[obj.contentType].id = obj.id;
						$this.localRecord.wAddress[obj.contentType].name = obj.name;
						$input.parents('label').removeClass('field-text_error');
					} else {
						$this.localRecord.wAddress[$input.attr('name')].id = null;
						$this.localRecord.wAddress[$input.attr('name')].name = '';
						if ($.trim($input.val())) {
							$input.parents('label').addClass('field-text_error');
						}
					}
				}
			});					
			$region.fias('type', $.fias.type.region);
		},

		txtForRegButton() {
			if (this.personRegTypeProp == "new") {
				return "Зарегистрироваться"
			} else if (this.personRegTypeProp == "customer") {
				return "Добавить заказчика"
			} else if (this.personRegTypeProp == "executor") {
				return "Добавить исполнителя"
			} else if (this.personRegTypeProp == "neworder") {
				return "Оформить заказ"
			}
		},

		typeOfStages() {
			if (this.personRegTypeProp == "executor") {
				return {
					juridical: ['Информация о компании','Контактное лицо','Информация о транспорте'],
					natural: ['Информация о физическом лице','Информация о транспорте'],
				}
			} else {
				return {
					juridical: ['Информация о компании','Контактное лицо','Авторизационные данные'],
					natural: ['Информация о физическом лице','Авторизационные данные'],
				}
			}
		},

		prevStage() {
			this.currentStage --
		},

		nextStage() {
			this.currentStage ++
		},

		sendform() {

				let post_data = this.fieldsVal[this.currentPT];

				if (this.formFilledRight) {
					$.ajax({
						url: "form.php",
						data: {
								"date": post_data,
								"record": this.localRecord,
								"units": this.wUnitAmounts,
						},
						dataType: "html",
						type: "post",
						success: function (data) {

								data = JSON.parse(data);

								if (data.success) {
									if (this.personRegTypeProp == "executor") {
										window.location.href = "/executor/" + data.ID + '/';
									} else if (this.personRegTypeProp == "customer") {
										window.location.href = "/customers/" + data.ID + '/';
									} else if (this.personRegTypeProp == "neworder") {
										window.location.href = "/orders/" + data.ID + '/';
									} else {
										window.location.href = "/orders/";
									}
								} else {
									alert = '<div class=\'row  wrap_alert_error\' >' +
													'<div class=\'offset-lg-1 col-lg-10 offset-xl-2 col-xl-8\'>' + 
														'<div class=\'block block_red block_p-40 error__alert\'>' + 
														data.error + 
													'</div>' + 
												'</div>' + 
											'</div>';

									$('.wrap_alert_error').remove();
									$('.title').after(alert);
								}

						}
					})
				} 

		},

		validateBik(bik, error) {
			var result = false;
			if (typeof bik === 'number') {
				bik = bik.toString();
			} else if (typeof bik !== 'string') {
				bik = '';
			}
			if (!bik.length) {
				error.code = 1;
				error.message = 'БИК пуст';
			} else if (/[^0-9]/.test(bik)) {
				error.code = 2;
				error.message = 'БИК может состоять только из цифр';
			} else if (bik.length !== 9) {
				error.code = 3;
				error.message = 'БИК может состоять только из 9 цифр';
			} else {
				result = true;
			}
			return result;
		},

		validateInn(inn) {

			var result = false;

			if (typeof inn === 'number') {
				inn = inn.toString();
			} else if (typeof inn !== 'string') {
				inn = '';
			}
			if (!inn.length) {
				// ИНН пуст
				return false;
			} else if (/[^0-9]/.test(inn)) {
				// ИНН может состоять только из цифр
				return false;
			} else if ([10, 12].indexOf(inn.length) === -1) {
				// ИНН может состоять только из 10 или 12 цифр
				return false;
			} else {
				var checkDigit = function (inn, coefficients) {
					var n = 0;
					for (var i in coefficients) {
						n += coefficients[i] * inn[i];
					}
					return parseInt(n % 11 % 10);
				};
				switch (inn.length) {
					case 10:
						var n10 = checkDigit(inn, [2, 4, 10, 3, 5, 9, 4, 6, 8]);
						if (n10 === parseInt(inn[9])) {
							result = true;
						}
						break;
					case 12:
						var n11 = checkDigit(inn, [7, 2, 4, 10, 3, 5, 9, 4, 6, 8]);
						var n12 = checkDigit(inn, [3, 7, 2, 4, 10, 3, 5, 9, 4, 6, 8]);
						if ((n11 === parseInt(inn[10])) && (n12 === parseInt(inn[11]))) {
							result = true;
						}
						break;
				}
			}
			return result;
		},
		
		validateKpp(kpp) {
			var result = false;
			if (typeof kpp === 'number') {
				kpp = kpp.toString();
			} else if (typeof kpp !== 'string') {
				kpp = '';
			}
			if (!kpp.length) {
				// кпп пуст 
				return false;
			} else if (kpp.length !== 9) {
				// КПП может состоять только из 9 знаков (цифр или заглавных букв латинского алфавита от A до Z)
				return false;
			} else if (!/^[0-9]{4}[0-9A-Z]{2}[0-9]{3}$/.test(kpp)) {
				// Неправильный формат КПП
				return false;
			} else {
				result = true;
			}
			return result;
		},

		validateKs(ks, bik, error) {
			var result = false;
			if (validateBik(bik, error)) {
				if (typeof ks === 'number') {
					ks = ks.toString();
				} else if (typeof ks !== 'string') {
					ks = '';
				}
				if (!ks.length) {
					error.code = 1;
					error.message = 'К/С пуст';
				} else if (/[^0-9]/.test(ks)) {
					error.code = 2;
					error.message = 'К/С может состоять только из цифр';
				} else if (ks.length !== 20) {
					error.code = 3;
					error.message = 'К/С может состоять только из 20 цифр';
				} else {
					var bikKs = '0' + bik.toString().slice(4, 6) + ks;
					var checksum = 0;
					var coefficients = [7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1];
					for (var i in coefficients) {
						checksum += coefficients[i] * (bikKs[i] % 10);
					}
					if (checksum % 10 === 0) {
						result = true;
					} else {
						error.code = 4;
						error.message = 'Неправильное контрольное число';
					}
				}
			}
			return result;
		},

		validateOgrn(ogrn, error) {
			var result = false;
			if (typeof ogrn === 'number') {
				ogrn = ogrn.toString();
			} else if (typeof ogrn !== 'string') {
				ogrn = '';
			}
			if (!ogrn.length) {
				error.code = 1;
				error.message = 'ОГРН пуст';
			} else if (/[^0-9]/.test(ogrn)) {
				error.code = 2;
				error.message = 'ОГРН может состоять только из цифр';
			} else if (ogrn.length !== 13) {
				error.code = 3;
				error.message = 'ОГРН может состоять только из 13 цифр';
			} else {
				var n13 = parseInt((parseInt(ogrn.slice(0, -1)) % 11).toString().slice(-1));
				if (n13 === parseInt(ogrn[12])) {
					result = true;
				} else {
					error.code = 4;
					error.message = 'Неправильное контрольное число';
				}
			}
			return result;
		},

		validateOgrnip(ogrnip, error) {
			var result = false;
			if (typeof ogrnip === 'number') {
				ogrnip = ogrnip.toString();
			} else if (typeof ogrnip !== 'string') {
				ogrnip = '';
			}
			if (!ogrnip.length) {
				error.code = 1;
				error.message = 'ОГРНИП пуст';
			} else if (/[^0-9]/.test(ogrnip)) {
				error.code = 2;
				error.message = 'ОГРНИП может состоять только из цифр';
			} else if (ogrnip.length !== 15) {
				error.code = 3;
				error.message = 'ОГРНИП может состоять только из 15 цифр';
			} else {
				var n15 = parseInt((parseInt(ogrnip.slice(0, -1)) % 13).toString().slice(-1));
				if (n15 === parseInt(ogrnip[14])) {
					result = true;
				} else {
					error.code = 4;
					error.message = 'Неправильное контрольное число';
				}
			}
			return result;
		},

		validateRs(rs, bik, error) {
			var result = false;
			if (validateBik(bik, error)) {
				if (typeof rs === 'number') {
					rs = rs.toString();
				} else if (typeof rs !== 'string') {
					rs = '';
				}
				if (!rs.length) {
					error.code = 1;
					error.message = 'Р/С пуст';
				} else if (/[^0-9]/.test(rs)) {
					error.code = 2;
					error.message = 'Р/С может состоять только из цифр';
				} else if (rs.length !== 20) {
					error.code = 3;
					error.message = 'Р/С может состоять только из 20 цифр';
				} else {
					var bikRs = bik.toString().slice(-3) + rs;
					var checksum = 0;
					var coefficients = [7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1, 3, 7, 1];
					for (var i in coefficients) {
						checksum += coefficients[i] * (bikRs[i] % 10);
					}
					if (checksum % 10 === 0) {
						result = true;
					} else {
						error.code = 4;
						error.message = 'Неправильное контрольное число';
					}
				}
			}
			return result;
		},

		validateSnils(snils, error) {
			var result = false;
			if (typeof snils === 'number') {
				snils = snils.toString();
			} else if (typeof snils !== 'string') {
				snils = '';
			}
			if (!snils.length) {
				error.code = 1;
				error.message = 'СНИЛС пуст';
			} else if (/[^0-9]/.test(snils)) {
				error.code = 2;
				error.message = 'СНИЛС может состоять только из цифр';
			} else if (snils.length !== 11) {
				error.code = 3;
				error.message = 'СНИЛС может состоять только из 11 цифр';
			} else {
				var sum = 0;
				for (var i = 0; i < 9; i++) {
					sum += parseInt(snils[i]) * (9 - i);
				}
				var checkDigit = 0;
				if (sum < 100) {
					checkDigit = sum;
				} else if (sum > 101) {
					checkDigit = parseInt(sum % 101);
					if (checkDigit === 100) {
						checkDigit = 0;
					}
				}
				if (checkDigit === parseInt(snils.slice(-2))) {
					result = true;
				} else {
					error.code = 4;
					error.message = 'Неправильное контрольное число';
				}
			}
			return result;
		},

		valdateName(name) {

			name = name.replace(/[^a-zA-Zа-яА-Я0-9]/g, '')
			if (name.length >= 2) {
				return true;
			}

			return false;
		},

		valdateMail(mail) {
			var re = /^[\w-\.]+@[\w-]+\.[a-z]{2,4}$/i;
			var valid = re.test(mail);
			return valid;
		}, 

		valdatePhone(phone) {
			phone = phone.replace(/[^0-9]/g, '');
			var re = /^\d[\d\(\)\ -]{7,14}\d$/;
			var valid = re.test(phone);
			return valid;
		},

		valdatePassSer(ser) {

			ser = ser.replace(/[^0-9]/g, '');

			if (ser.length >= 4) {
				return true;
			} else {
				return false;
			}

		},

		valdatePassNum(num) {

			num = num.replace(/[^0-9]/g, '');

			if (num.length >= 6) {
				return true;
			} else {
				return false;
			}

		},

		valdatePassDate(date) {
		
			date = date.replace(/[^0-9]/g, '');

			if (date.length >= 6) {
				return true;
			} else {
				return false;
			}
		},

		valdateLogin(login) {
		
			var reg=/^[a-zA-Z0-9]+$/;

			if (!reg.test(login)) {
				return false;
			}

			if (login.length >= 3) {
				return true;
			} else {
				return false;
			}
		},

		valdatePass(pas, confpass) {

			if ((pas.length >= 6) && (confpass.length >= 6) && (pas === confpass)) {
				return true;
			} else {
				return false;
			}
		},
	},
	template: `
		<div>
	

		<!-- Debug --->
		
		
		<div style="display: block; position: fixed; right: 0;top: 0%; background-color:#fff; z-index:1000; width: 300px; padding: 10px; border: 1px solid #999;">
			<pre>
				{{ wUnitAmounts }}
			</pre>	
		</div>
		

		<!-- end Debug --->

			<!-- Stages -->
			<div class="order-registration__stages">
					
				<div class="block_bg-color-white block_cyan-b block_orange-t block_p-50">
					
					<div class="order-registration__stages-navs">

						<div	@click="prevStage"
									:class="['order-registration__stages-nav-prev', firstStage ? 'disabled' : '']"
						>
							<span class="icon  icon_some-mod i-angle-arrow-left"></span>
						</div>

						<div	@click="nextStage"
									:class="['order-registration__stages-nav-next', lastStage ? 'disabled':'']"
						>
							<span class="icon  icon_some-mod i-angle-arrow-right"></span>
						</div>

					</div>
					

					<div class="order-registration__stages-wrap">
						
						<a 	href="" 
							:class="['order-registration__stages-item', (index === currentStage) ? 'active' : '']"
							v-for="(stage, index) in stages[currentPT]"
							:key="index"
							@click.prevent="currentStage = index">

							<span class="order-registration__stages-num">{{ index + 1 }}</span>
							<span class="order-registration__stages-caption">{{ stage }}</span>
						</a>

					</div>

				</div>
			</div>

			<!-- Form content -->
			<div class="block_yellow block_bg-color-white block_p-40">

				<!-- Yuridicheskoe litso -->
				<template v-if="currentPT === 'juridical'">

					<div 	class="order-registration__stage-block"
								v-if="currentStage === 0"
					>
						<!-- Информация о компании -->
						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Информация о компании</legend>
									
									<div class="block_orange-b">
										<label 
											:class="['field-text']"
										>
											<span class="field-text__name">Наименование</span>

											<ValidationProvider
												class="field-text__input-wrap"
												name="Наименование"
												v-slot="{ errors }"
											>
												<input	type="text" 
																name="companyName"
																placeholder="Наименование"
																class="field-text__input"
																v-model="fieldsVal.juridical.companyName"
												>
												<!-- <span v-show="errors.has('companyName')" class="field-text__help-text">{{errors.first('companyName')}}</span> -->
												<span>{{ errors[0] }}</span>
											</ValidationProvider>

										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">ИНН <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input	type="text"
																name="companyInn"
																placeholder="ИНН" 
																class="field-text__input"
																v-model="fieldsVal.juridical.companyInn"
																
												>
											</span>
										</label>

									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">КПП <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input	type="text"
																name="companyKpp"
																placeholder="КПП"
																class="field-text__input"
																v-model="fieldsVal.juridical.companyKpp"
																
												>
											</span>
										</label>
									</div>

									<label class="field-text">
										<span class="field-text__name">Юридический адрес <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="text"
															name="companyJurAddress"
															placeholder="Юридический адрес"
															class="field-text__input"
															v-model="fieldsVal.juridical.companyJurAddress"
											>
										</span>
									</label>

								</fieldset>
							</div>
						</div>
						
						<div class="hr"></div>
						
						<!-- Банковские реквизиты -->
						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Банковские реквизиты</legend>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Наименование банка</span>
											<span class="field-text__input-wrap">
												<input 	type="text"
																name="companyBankName"
																placeholder="Наименование банка"
																class="field-text__input"
																v-model="fieldsVal.juridical.companyBankName"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Р/с</span>
											<span class="field-text__input-wrap">
												<input	type="text"
																placeholder="Р/с"
																class="field-text__input"
																v-model="fieldsVal.juridical.companyBankAcount"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Кор/счёт</span>
											<span class="field-text__input-wrap">
												<input	type="text"
																placeholder="Кор/счёт"
																class="field-text__input"
																v-model="fieldsVal.juridical.companyBankCorrAcount"
												>
											</span>
										</label>
									</div>
									

									<label class="field-text">
										<span class="field-text__name">БИК</span>
										<span class="field-text__input-wrap">
											<input	type="text" 
															placeholder="БИК" 
															class="field-text__input"
															v-model="fieldsVal.juridical.companyBankBik"
											>
										</span>
									</label>

								</fieldset>								
							</div>
						</div>
					</div>

					<div 	class="order-registration__stage-block"
								v-else-if="currentStage === 1"
					>
						<!-- Руководитель -->
						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Руководитель</legend>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Должность</span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="Должность"
																class="field-text__input"
																v-model="fieldsVal.juridical.companyChiefPost"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">ФИО <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text"
																placeholder="ФИО"
																class="field-text__input"
																v-model="fieldsVal.juridical.companyChiefFullname"
												>
											</span>
										</label>
									</div>

									<label class="field-text">
										<span class="field-text__name">Действует на основании <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input	type="text" 
															placeholder="Действует на основании"
															class="field-text__input"
															v-model="fieldsVal.juridical.companyChiefActingUnder"
											>
										</span>
									</label>

								</fieldset>
							</div>
						</div>
						
						<div class="hr"></div>

						<!-- Контактное лицо -->
						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Контактное лицо</legend>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Должность</span>
											<span class="field-text__input-wrap">
												<input 	type="text"
																placeholder="Должность"
																class="field-text__input"
																v-model="fieldsVal.juridical.companyContactPost"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Фамилия <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="Фамилия" 
																class="field-text__input"
																v-model="fieldsVal.juridical.companyContactSecondName"
												>
											</span>
										</label>
									</div>

									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Имя<span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="Имя" 
																class="field-text__input"
																v-model="fieldsVal.juridical.companyContactFirstName"
												>
											</span>
										</label>
									</div>

									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Отчество<span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="Отчество" 
																class="field-text__input"
																v-model="fieldsVal.juridical.companyContactLastName"
												>
											</span>
										</label>
									</div>

									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">E-mail <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="E-mail" 
																class="field-text__input"
																v-model="fieldsVal.juridical.companyContactEmail"
												>
											</span>
										</label>
									</div>

									<label class="field-text">
										<span class="field-text__name">Контактный телефон <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input	type="text" 
															placeholder="Контактный телефон" 
															
															class="field-text__input"
															v-model="fieldsVal.juridical.companyContactPhone"
											>
										</span>
									</label>

								</fieldset>
							</div>
						</div>
					</div>
					
					<div 	class="order-registration__stage-block"
							v-else-if="(currentStage === 2) && (is_executor)"
					>
						<!-- Информация о транспорте -->
						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Информация о транспорте</legend>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__input-wrap">
											
												<field-select 
													v-bind="wGroupSelect"
													:init="localRecord.wGroup"
													@change="selectTrans($event)"
												>
												</field-select>

											</span>
										</label>
									</div>

									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">
												Транспорт <span style="color: red;">*</span>
											</span>
											<span class="field-text__input-wrap">
												<input	type="text" 
																placeholder="Транспорт" 
																class="field-text__input"
																v-model="fieldsVal.juridical.companyTrans"
												>
											</span>
										</label>
									</div>

									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">
												Гос. номер <span style="color: red;">*</span>
											</span>
											<span class="field-text__input-wrap">
												<input	type="text" 
																placeholder="Гос. номер" 
																class="field-text__input"
																v-model="fieldsVal.juridical.companyGovNum"
												>
											</span>
										</label>
									</div>

									<label class="field-text">
										<span class="field-text__name">Комментарий</span>
										<span class="field-text__input-wrap">
											<textarea	class="field-text__input" 
																name="comment" 
																placeholder="Комментарий"
																v-model="fieldsVal.juridical.companyExtraComment"
											></textarea>
										</span>
									</label>

								</fieldset>
							</div>
						</div>

						<div class="hr"></div>

						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Транспортировка</legend>
									
									<div class="block_orange-b">
										<fieldset class="form__fieldset form__fieldset_address" ref="address">
											<label class="field-text">
												<span class="field-text__name">
													Область транспортировки<span style="color: red;">*</span>
												</span>
												<span class="field-text__input-wrap">
													<input 
														name="region"	
														type="text" 
														placeholder="Область" 
														class="field-text__input"
														@click="fiasInit()"
														v-model="localRecord.wAddress.region.name"
													/>
												</span>
											</label>
										</fieldset>
									</div>

								
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">
												Стоимость транспортировки за 1 км <span style="color: red;">*</span>
											</span>
											<span class="field-text__input-wrap">
												<input	type="text" 
																placeholder="Стоимость транспортировки" 
																class="field-text__input"
																v-model="fieldsVal.juridical.companyTransportCostPerKm"
												>
											</span>
										</label>
									</div>


								</fieldset>
							</div>
						</div>
					

						<div class="hr"></div>

						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
									<fieldset class="form__fieldset form__fieldset_address">
									<legend class="form__legend">Характеристики</legend>

									<div class="block_purple-b" v-for="(unitItem, index) in wUnitAmounts">
										<div class="row">
											<div class="col-8 col-sm-8">
												<label class="field-text">
													<span class="field-text__name">Вместимость<span style="color: red;">*</span></span>
													<span class="field-text__input-wrap">
														<input 	
															name="vmes"
															type="text" 
															placeholder="Количество" 
															class="field-text__input"
															v-model="unitItem.amount"
														>
													</span>
												</label>
											</div>

											<div class="col-4 col-sm-4">
												<label class="field-text">
													<span class="field-text__input-wrap">
														<field-select 
															v-bind="wUnitsSelect"
															:init="unitItem"
															@change="addСapacity(index,$event)"
														>
														</field-select>
													</span>
												</label>
											</div>

											<div class="add-btn" 
													v-if="((index === wUnitAmounts.length-1) && (index < (wUnitsSelect.options.length - 2)))">
												<a class="btn  btn_secondary btn_icon" 
													href="javascript:void(0);"
													@click="addUnit(index)">
													<span class="btn__icon i-plus"></span>
												</a>
											</div>

										</div>
									</div>

								</fieldset>

							</div>
						</div>

					</div>


					<div 	class="order-registration__stage-block"
								v-else-if="(currentStage === 2) && (!is_executor)"
					>
						<!-- Авторизационные данные -->
						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Авторизационные данные</legend>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Логин<span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input	type="text" 
																placeholder="Логин" 
																class="field-text__input"
																v-model="fieldsVal.juridical.companyAuthLogin"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Пароль <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="password" 
																placeholder="Пароль" 
																name="password"
																class="field-text__input"
																v-model="fieldsVal.juridical.companyAuthPass"
												>
											</span>
										</label>
									</div>

									<label class="field-text">
										<span class="field-text__name">Повторите пароль <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="password" 
															placeholder="Повторите пароль" 
															name="passrepeat"
															class="field-text__input"
															v-model="fieldsVal.juridical.companyAuthPassRepeat"
											>
										</span>
									</label>

								</fieldset>
							</div>
						</div>
					</div>
				</template>

				<!-- Fizicheskoe litso -->
				<template v-else>

					<div 	class="order-registration__stage-block"
								v-if="currentStage === 0"
					>

						<!-- Информация о физическом лице -->
						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Информация о физическом лице</legend>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Фамилия <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input	type="text" 
																placeholder="Фамилия" 
																class="field-text__input"
																v-model="fieldsVal.natural.personInfoLastname"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Имя <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input	type="text" 
																placeholder="Имя" 
																class="field-text__input"
																v-model="fieldsVal.natural.personInfoFirstname"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Отчество <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="Отчество" 
																class="field-text__input"
																v-model="fieldsVal.natural.personInfoPatronymic"
												>
											</span>
										</label>
									</div>

									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">E-mail <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="E-mail" 
																class="field-text__input"
																v-model="fieldsVal.natural.personInfoEmail"
												>
											</span>
										</label>
									</div>

									<label class="field-text">
										<span class="field-text__name">Телефон <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="+ 7 (___) ___ __ __" 
															
															class="field-text__input"
															v-model="fieldsVal.natural.personInfoPhone"
											>
										</span>
									</label>

								</fieldset>
							</div>
						</div>
						
						<div class="hr"></div>

						<!-- Паспортные данные -->
						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Паспортные данные</legend>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Серия <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
														
														placeholder="Серия" 
														class="field-text__input"
														v-model="fieldsVal.natural.personPassportSeries"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Номер <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
														
														placeholder="Номер" 
														class="field-text__input"
														v-model="fieldsVal.natural.personPassportNumber"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Кем выдан <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="Кем выдан" 
																class="field-text__input"
																v-model="fieldsVal.natural.personPassportIssuedBy"
												>
											</span>
										</label>
									</div>

									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Дата выдачи <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																
																placeholder="Дата выдачи" 
																class="field-text__input"
																v-model="fieldsVal.natural.personPassportIssuedDate"
												>
											</span>
										</label>
									</div>

									<label class="field-text">
										<span class="field-text__name">Код подразделения <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="Код подразделения" 
															class="field-text__input"
															v-model="fieldsVal.natural.personPassportDepartmentCode"
											>
										</span>
									</label>

								</fieldset>
							</div>
						</div>
						
						<div class="hr"></div>

						<!-- Адрес -->
						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Адрес</legend>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Область</span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="Область" 
																class="field-text__input"
																v-model="fieldsVal.natural.personAddressRegion"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Населенный пункт</span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="Населенный пункт" 
																class="field-text__input"
																v-model="fieldsVal.natural.personAddressCity"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Улица</span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="Улица" 
																class="field-text__input"
																v-model="fieldsVal.natural.personAddressStreet"
												>
											</span>
										</label>
									</div>

									<label class="field-text">
										<span class="field-text__name">Дом</span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="Дом" 
															class="field-text__input"
															v-model="fieldsVal.natural.personAddressBuilding"
											>
										</span>
									</label>

								</fieldset>
							</div>
						</div>

					</div>


					<div 	class="order-registration__stage-block"
							v-else-if="(currentStage === 1) && (is_executor)"
					>


						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Информация о транспорте</legend>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__input-wrap">
											
												<field-select 
													v-bind="wGroupSelect"
													:init="localRecord.wGroup"
													@change="selectTrans($event)"
												>
												</field-select>

											</span>
										</label>
									</div>

									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">
												Транспорт <span style="color: red;">*</span>
											</span>
											<span class="field-text__input-wrap">
												<input	type="text" 
																placeholder="Транспорт" 
																class="field-text__input"
																v-model="fieldsVal.natural.personTrans"
												>
											</span>
										</label>
									</div>

									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">
												Гос. номер <span style="color: red;">*</span>
											</span>
											<span class="field-text__input-wrap">
												<input	type="text" 
																placeholder="Гос. номер" 
																class="field-text__input"
																v-model="fieldsVal.natural.personGovNum"
												>
											</span>
										</label>
									</div>

									<label class="field-text">
										<span class="field-text__name">Комментарий</span>
										<span class="field-text__input-wrap">
											<textarea	class="field-text__input" 
																name="comment" 
																placeholder="Комментарий"
																v-model="fieldsVal.natural.personExtraComment"
											></textarea>
										</span>
									</label>

								</fieldset>
							</div>
						</div>

						<div class="hr"></div>

						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Транспортировка</legend>
									
									<div class="block_orange-b">
										<fieldset class="form__fieldset form__fieldset_address" ref="address">
											<label class="field-text">
												<span class="field-text__name">
													Область транспортировки<span style="color: red;">*</span>
												</span>
												<span class="field-text__input-wrap">
													<input 
														name="region"	
														type="text" 
														placeholder="Область" 
														class="field-text__input"
														@click="fiasInit()"
														v-model="localRecord.wAddress.region.name"
													/>
												</span>
											</label>
										</fieldset>
									</div>

								
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">
												Стоимость транспортировки за 1 км <span style="color: red;">*</span>
											</span>
											<span class="field-text__input-wrap">
												<input	type="text" 
																placeholder="Стоимость транспортировки" 
																class="field-text__input"
																v-model="fieldsVal.natural.personTransportCostPerKm"
												>
											</span>
										</label>
									</div>
									

								</fieldset>
							</div>
						</div>
					

						<div class="hr"></div>

						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
									<fieldset class="form__fieldset form__fieldset_address">
									<legend class="form__legend">Характеристики</legend>

									<div class="block_purple-b" v-for="(unitItem, index) in wUnitAmounts">
										<div class="row">
											<div class="col-8 col-sm-8">
												<label class="field-text">
													<span class="field-text__name">Вместимость<span style="color: red;">*</span></span>
													<span class="field-text__input-wrap">
														<input 	
															name="nums"
															type="text" 
															placeholder="Количество" 
															class="field-text__input"
															v-model="unitItem.amount"
														>
													</span>
												</label>
											</div>

											<div class="col-4 col-sm-4">
												<label class="field-text">
													<span class="field-text__input-wrap">
														<field-select 
															v-bind="wUnitsSelect"
															:init="unitItem"
															@change="addСapacity(index,$event)"
														>
														</field-select>
													</span>
												</label>
											</div>

											<div class="add-btn" 
													v-if="((index === wUnitAmounts.length-1) && (index < (wUnitsSelect.options.length - 2)))">
												<a class="btn  btn_secondary btn_icon" 
													href="javascript:void(0);"
													@click="addUnit(index)">
													<span class="btn__icon i-plus"></span>
												</a>
											</div>

										</div>
									</div>

								</fieldset>

							</div>
						</div>
					
					</div>


					<div 	class="order-registration__stage-block"
								v-else-if="(currentStage === 1) && (!is_executor)"
					>
						<!-- Авторизационные данные -->
						<div class="row">
							<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset">
									<legend class="form__legend">Авторизационные данные</legend>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Логин<span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="text" 
																placeholder="Логин" 
																class="field-text__input"
																v-model="fieldsVal.natural.personAuthLogin"
												>
											</span>
										</label>
									</div>
									
									<div class="block_orange-b">
										<label class="field-text">
											<span class="field-text__name">Пароль <span style="color: red;">*</span></span>
											<span class="field-text__input-wrap">
												<input 	type="password" 
														
																placeholder="Пароль" 
																class="field-text__input"
																v-model="fieldsVal.natural.personAuthPass"
												>
											</span>
										</label>
									</div>

									<label class="field-text">
										<span class="field-text__name">Повторите пароль <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="password" 
															placeholder="Повторите пароль" 
															class="field-text__input"
															v-model="fieldsVal.natural.personAuthPassRepeat"
											>
										</span>
									</label>

								</fieldset>
							</div>
						</div>
					</div>

				</template>
		

				<!-- Action buttons -->
				<div class="field-actions">
					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<div class="field-actions__text">
								<span style="color: red;">* </span>— поля, обязательные для заполнения
							</div>
						</div>
					</div>

					<div class="d-flex justify-content-between">
						<button type="button" 
										:class="['btn  btn_secondary', firstStage ? 'invisible' : '']"
										:disabled="firstStage"
										@click="prevStage"
						>Назад</button>

						
						<button
										class="btn btn_primary" 
										v-if="lastStage"
										type="submit"
										:disabled="!formFilledRight"
										@click="sendform"
						>{{ buttonRegTxt }}</button>
						
						<div
							v-if="!lastestStage">
							<button type="button"
							class="btn btn_primary" 
							@click="nextStage"
							v-if="(!lastStage)"
							:disabled="nextpage"
							>Далее</button>
						</div>
						
					</div>

				</div>

			</div>
		</div>

	`
})