/* eslint-disable no-undef */
import axios from 'axios';
import $ from 'jquery';
import { async } from 'q';
import { TSThisType } from 'babel-types';

Vue.component('app-ex-registration-form', {
	props: {
		personType: {
			type: String
		}
	},
	data: function () {
		return {
			wGroupSelect: {
				title: 'Вид транспорта',
				attrs: {
					name: 'trans-types',
					id: 'trans-types',
					required: true
				},
				options: [],
				settings: {
					searchEnabled: true,
					shouldSort: false,
	  	    noChoicesText: 'Пусто',
					noResultsText: 'Ничего не найдено',
				},
				helptext: ''
			},
			wUnitsSelect: {
				title: 'Ед. Изм.',
				attrs: {
					name: 'units',
					id: 'units',
					required: true
				},
				options: [],
				settings: {
					searchEnabled: false,
					shouldSort: false,
	  	    noChoicesText: 'Пусто',
  	  	  noResultsText: 'Ничего не найдено',
				},
				helptext: ''
			},
			wUnitAmounts: [{}],
			stages: {
				juridical: ['Информация о компании','Контактное лицо','Информация о транспорте'],
				natural: ['Информация о физическом лице','Информация о транспорте'],
			},
			fieldsVal: {
				juridical: {
					companyName: '',
					companyInn: '',
					companyKpp: '',
					companyJurAddress: '',

					companyBankName: '',
					companyBankAcount: '',
					companyBankCorrAcount: '',
					companyBankBik: '',

					companyChiefPost: '',
					companyChiefFullname: '',
					companyChiefActingUnder : '',

					companyContactPost: '',
					companyContactFullname: '',
					companyContactEmail: '',
					companyContactPhone: '',

					companyTransportType: '',
					companyTransportGovNumber: '',
					companyTransportComment: '',
					companyTransportCostPerKm: '',
					

					companyAuthLogin: '',
					companyAuthPass: '',
					companyAuthPassRepeat: '',
				},
				natural: {
					personInfoLastname: '',
					personInfoFirstname: '',
					personInfoPatronymic: '',
					personInfoEmail: '',
					personInfoPhone: '',

					personPassportSeries: '',
					personPassportNumber: '',
					personPassportIssuedBy: '',
					personPassportIssuedDate: '',
					personPassportDepartmentCode: '',

					personAddressRegion: '',
					personAddressCity: '',
					personAddressStreet: '',
					personAddressBuilding: '',

					personExtraDate: '',
					personExtraComment: '',

					personAuthLogin: '',
					personAuthPass: '',
					personAuthPassRepeat: '',
				}
			},
			currentPT: this.personType, //текущий тип клиента
			currentStage: 0,
		}
	},
	created() {
		this.localRecord =  {
			wGroup: {},
			wAddress: {
				region: {
					id: null,
					name: ''
				}
			},
		};

		this.transportGroupLoad();
	},
	computed: {
		firstStage() {
			return this.currentStage === 0
		},
		lastStage() {
			return this.currentStage >= this.stages[this.currentPT].length - 1
		},


		//кнопка добавить
		formFilledRight() {
			return 	((this.fieldsVal.juridical.companyBankBik !== ''));
		}
	},
	watch: {
		personType() {
			this.currentPT = this.personType;
			this.currentStage = 0
		},
		fieldsVal: {
			handler() {
				// console.log('Field changes')
			},
			deep: true
		},
	},
	methods: {
		selectTrans(e){
			this.localRecord.wGroup = e;
			this.transportUnitsLoad();
		},
		addUnit(index){
			alert(this.wUnitsSelect.options.length);
			this.wUnitAmounts.push({});
		},
		test3(index,e){
			this.wUnitAmounts[index].value = e.value;
			this.wUnitAmounts[index].label = e.caption;
			//alert(JSON.stringify(e));
		},
		transportGroupUrl(){
			return 'https://r52.ru/api/transport/getTypes/';
		},
		transportUnitsUrl(id){
			return 'https://r52.ru/api/transport/getUnits/' + id;
		},
		transportGroupLoad(){
			axios
			.get(this.transportGroupUrl())
			.then(response => response.data)
			.then(options => {
				this.wGroupSelect.options = options;
				//this.$set(this.wGroupSelect, 'options', options);
				//this.localRecord.wGroup = options[0];	
				//this.transportUnitsLoad();
			})
		},
		transportUnitsLoad(){
			axios
			.get(this.transportUnitsUrl())
			.then(response => response.data)
			.then(options => {
				this.$set(this.wUnitsSelect, 'options', options);
				this.wUnitAmounts = [{}];
				//this.wUnitAmounts[0] = options[0];
			})
		},
		fiasInit() {
			let $this = this;
			$.fias.token = 'tiyhha6YHyNi6EfeyfrRrdrDQkyehf59';
			$.fias.url = 'https://kladr-api.com/api.php';
			let $container = $(this.$refs.address);
			let $region = $container.find('[name="region"]');
			$.fias.setDefault({
				parentInput: $container,
				verify: true,
				select: function (obj) {},
				checkBefore: function () {
					let $input = $(this);
					if (!$.trim($input.val())) {
						$input.parents('label').removeClass('field-text_error');
						return false;
					}
				},
				check: function (obj) {
					let $input = $(this);
					if (obj) {
						$input.parents('label').removeClass('field-text_error');
					}
					else {
						$input.parents('label').addClass('field-text_error');
					}
				},
				change: function (obj) {
					let $input = $(this);
					if (obj) {
						if (obj.parents) {
							$.fias.setValues(obj.parents, $container);
						}
						$this.localRecord.wAddress[obj.contentType].id = obj.id;
						$this.localRecord.wAddress[obj.contentType].name = obj.name;
						$input.parents('label').removeClass('field-text_error');
					} else {
						$this.localRecord.wAddress[$input.attr('name')].id = null;
						$this.localRecord.wAddress[$input.attr('name')].name = '';
						if ($.trim($input.val())) {
							$input.parents('label').addClass('field-text_error');
						}
					}
				}
			});					
			$region.fias('type', $.fias.type.region);
		},
		prevStage() {
			this.currentStage --
		},
		nextStage() {
			this.currentStage ++
		},
		orderProcessing() {

			$.ajax({
				url: "addNewCustomer.php",
				data: {
						"data": this.fieldsVal[this.currentPT],
				},
				dataType: "html",
				type: "post",
				success: function (data) {
						$('.results').html(data);
						window.location.href = "/customers/";
				}
			});

		}
	},
	template: `
	<div>
		
		<!-- Debug --->
		
		<div style="display: block; position: fixed; right: 0;top: 0%; background-color:#fff; z-index:1000; width: 300px; padding: 10px; border: 1px solid #999;">
			{{ fieldsVal[currentPT] }}
		</div>

		<div style="display: block; position: fixed; left: 0;top: 0%; background-color:#fff; z-index:1000; width: 300px; padding: 10px; border: 1px solid #999;">
			<pre>
			{{ localRecord }}<br><br>
			{{ wUnitAmounts }}
			</pre>
		</div>
		
		<!-- end Debug --->


		<!-- Stages -->
		<div class="order-registration__stages">
				
			<div class="block_bg-color-white block_cyan-b block_orange-t block_p-50">
				
				<div class="order-registration__stages-navs">

					<div	@click="prevStage"
								:class="['order-registration__stages-nav-prev', firstStage ? 'disabled' : '']"
					>
						<span class="icon  icon_some-mod i-angle-arrow-left"></span>
					</div>

					<div	@click="nextStage"
								:class="['order-registration__stages-nav-next', lastStage ? 'disabled':'']"
					>
						<span class="icon  icon_some-mod i-angle-arrow-right"></span>
					</div>

				</div>
				
				<div class="order-registration__stages-wrap">
					<a 	href="" 
							:class="['order-registration__stages-item', (index === currentStage) ? 'active' : '']"
							v-for="(stage, index) in stages[currentPT]"
							:key="index"
							@click.prevent="currentStage = index"
					>
						<span class="order-registration__stages-num">{{ index + 1 }}</span>
						<span class="order-registration__stages-caption">{{ stage }}</span>
					</a>

				</div>

			</div>
		</div>

		<!-- Form content -->
		<form class="block_yellow block_bg-color-white block_p-40" action="javascript:void(0);">

			<!-- Yuridicheskoe litso -->
			<template v-if="currentPT === 'juridical'">

				<div 	class="order-registration__stage-block"
							v-if="currentStage === 0"
				>
					<!-- Информация о компании -->
					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<fieldset class="form__fieldset">
								<legend class="form__legend">Информация о компании</legend>
								
								<div class="block_orange-b">
									<label 
										:class="['field-text']"
									>
										<span class="field-text__name">Наименование <span style="color: red;">*</span></span>

										<ValidationProvider
											class="field-text__input-wrap"
											name="Наименование"
											v-slot="{ errors }"
										>
											<input	type="text" 
															name="companyName"
															placeholder="Наименование"
															class="field-text__input"
															v-model="fieldsVal.juridical.companyName"
											>
											<!-- <span v-show="errors.has('companyName')" class="field-text__help-text">{{errors.first('companyName')}}</span> -->
											<span>{{ errors[0] }}</span>
										</ValidationProvider>

									</label>
								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">ИНН <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input	type="text"
															placeholder="ИНН" 
															class="field-text__input"
															v-model="fieldsVal.juridical.companyInn"
											>
										</span>
									</label>

								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">КПП <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input	type="text"
															placeholder="КПП"
															class="field-text__input"
															v-model="fieldsVal.juridical.companyKpp"
											>
										</span>
									</label>
								</div>

								<label class="field-text">
									<span class="field-text__name">Юридический адрес <span style="color: red;">*</span></span>
									<span class="field-text__input-wrap">
										<input 	type="text"
														placeholder="Юридический адрес"
														class="field-text__input"
														v-model="fieldsVal.juridical.companyJurAddress"
										>
									</span>
								</label>

							</fieldset>
						</div>
					</div>
					
					<div class="hr"></div>
					
					<!-- Банковские реквизиты -->
					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<fieldset class="form__fieldset">
								<legend class="form__legend">Банковские реквизиты</legend>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Наименование банка</span>
										<span class="field-text__input-wrap">
											<input 	type="text"
															placeholder="Наименование банка"
															class="field-text__input"
															v-model="fieldsVal.juridical.companyBankName"
											>
										</span>
									</label>
								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Р/с</span>
										<span class="field-text__input-wrap">
											<input	type="text"
															placeholder="Р/с"
															class="field-text__input"
															v-model="fieldsVal.juridical.companyBankAcount"
											>
										</span>
									</label>
								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Кор/счёт</span>
										<span class="field-text__input-wrap">
											<input	type="text"
															placeholder="Кор/счёт"
															class="field-text__input"
															v-model="fieldsVal.juridical.companyBankCorrAcount"
											>
										</span>
									</label>
								</div>
								

								<label class="field-text">
									<span class="field-text__name">БИК</span>
									<span class="field-text__input-wrap">
										<input	type="text" 
														placeholder="БИК" 
														class="field-text__input"
														v-model="fieldsVal.juridical.companyBankBik"
										>
									</span>
								</label>

							</fieldset>								
						</div>
					</div>
				</div>

				<div 	class="order-registration__stage-block"
							v-else-if="currentStage === 1"
				>
					<!-- Руководитель -->
					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<fieldset class="form__fieldset">
								<legend class="form__legend">Руководитель</legend>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Должность</span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="Должность"
															class="field-text__input"
															v-model="fieldsVal.juridical.companyChiefPost"
											>
										</span>
									</label>
								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">ФИО <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="text"
															placeholder="ФИО"
															class="field-text__input"
															v-model="fieldsVal.juridical.companyChiefFullname"
											>
										</span>
									</label>
								</div>

								<label class="field-text">
									<span class="field-text__name">Действует на основании <span style="color: red;">*</span></span>
									<span class="field-text__input-wrap">
										<input	type="text" 
														placeholder="Действует на основании"
														class="field-text__input"
														v-model="fieldsVal.juridical.companyChiefActingUnder"
										>
									</span>
								</label>

							</fieldset>
						</div>
					</div>
					
					<div class="hr"></div>

					<!-- Контактное лицо -->
					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<fieldset class="form__fieldset">
								<legend class="form__legend">Контактное лицо</legend>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Должность</span>
										<span class="field-text__input-wrap">
											<input 	type="text"
															placeholder="Должность"
															class="field-text__input"
															v-model="fieldsVal.juridical.companyContactPost"
											>
										</span>
									</label>
								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">ФИО <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="ФИО" 
															class="field-text__input"
															v-model="fieldsVal.juridical.companyContactFullname"
											>
										</span>
									</label>
								</div>

								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">E-mail <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="E-mail" 
															class="field-text__input"
															v-model="fieldsVal.juridical.companyContactEmail"
											>
										</span>
									</label>
								</div>

								<label class="field-text">
									<span class="field-text__name">Контактный телефон <span style="color: red;">*</span></span>
									<span class="field-text__input-wrap">
										<input	type="text" 
														placeholder="Контактный телефон" 
														class="field-text__input"
														v-model="fieldsVal.juridical.companyContactPhone"
										>
									</span>
								</label>

							</fieldset>
						</div>
					</div>
				</div>
				

				<div 	class="order-registration__stage-block"
							v-else-if="currentStage === 2"
				>
					<!-- Информация о транспорте -->
					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<fieldset class="form__fieldset">
								<legend class="form__legend">Информация о транспорте</legend>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__input-wrap">
										
											<field-select 
												v-bind="wGroupSelect"
												:init="localRecord.wGroup"
												@change="selectTrans($event)"
											>
											</field-select>

										</span>
									</label>
								</div>

								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">
											Транспорт <span style="color: red;">*</span>
										</span>
										<span class="field-text__input-wrap">
											<input	type="text" 
															placeholder="Транспорт" 
															class="field-text__input"
															v-model="fieldsVal.juridical.companyContactPhone"
											>
										</span>
									</label>
								</div>

								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">
											Гос. номер <span style="color: red;">*</span>
										</span>
										<span class="field-text__input-wrap">
											<input	type="text" 
															placeholder="Гос. номер" 
															class="field-text__input"
															v-model="fieldsVal.juridical.companyContactPhone"
											>
										</span>
									</label>
								</div>

								<label class="field-text">
									<span class="field-text__name">Комментарий</span>
									<span class="field-text__input-wrap">
										<textarea	class="field-text__input" 
															name="comment" 
															placeholder="Комментарий"
															v-model="fieldsVal.juridical.companyExtraComment"
										></textarea>
									</span>
								</label>

							</fieldset>
						</div>
					</div>

					<div class="hr"></div>

					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<fieldset class="form__fieldset">
								<legend class="form__legend">Транспортировка</legend>
								
								<div class="block_orange-b">
									<fieldset class="form__fieldset form__fieldset_address" ref="address">
										<label class="field-text">
											<span class="field-text__name">
												Область транспортировки<span style="color: red;">*</span>
											</span>
											<span class="field-text__input-wrap">
												<input 
													name="region"	
													type="text" 
													placeholder="Область" 
													class="field-text__input"
													@click="fiasInit()"
													v-model="localRecord.wAddress.region.name"
												/>
											</span>
										</label>
									</fieldset>
								</div>

							
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">
											Стоимость транспортировки за 1 км <span style="color: red;">*</span>
										</span>
										<span class="field-text__input-wrap">
											<input	type="text" 
															placeholder="Стоимость транспортировки" 
															class="field-text__input"
															v-model="fieldsVal.juridical.companyTransportCostPerKm"
											>
										</span>
									</label>
								</div>


							</fieldset>
						</div>
					</div>
				

					<div class="hr"></div>

					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset form__fieldset_address">
								<legend class="form__legend">Характеристики</legend>

								<div class="block_purple-b" v-for="(unitItem, index) in wUnitAmounts">
									<div class="row">
										<div class="col-8 col-sm-8">
											<label class="field-text">
												<span class="field-text__name">Вместимость<span style="color: red;">*</span></span>
												<span class="field-text__input-wrap">
													<input 	
														name="street"
														type="text" 
														placeholder="Количество" 
														class="field-text__input"
														v-model="unitItem.amount"
													>
												</span>
											</label>
										</div>

										<div class="col-4 col-sm-4">
											<label class="field-text">
												<span class="field-text__input-wrap">
													<field-select 
														v-bind="wUnitsSelect"
														:init="unitItem"
														@change="test3(index,$event)"
													>
													</field-select>
												</span>
											</label>
										</div>

										<div class="add-btn" 
												 v-if="((index === wUnitAmounts.length-1) && (index < (wUnitsSelect.options.length - 1)))">
											<a class="btn  btn_secondary btn_icon" 
												href="javascript:void(0);"
												@click="addUnit(index)">
												<span class="btn__icon i-plus"></span>
											</a>
										</div>

									</div>
								</div>

							</fieldset>

						</div>
					</div>

				</div>

			</template>

			<!-- Fizicheskoe litso -->
			<template v-else>

				<div 	class="order-registration__stage-block"
							v-if="currentStage === 0"
				>

					<!-- Информация о физическом лице -->
					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<fieldset class="form__fieldset">
								<legend class="form__legend">Информация о физическом лице</legend>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Фамилия</span>
										<span class="field-text__input-wrap">
											<input	type="text" 
															placeholder="Фамилия" 
															class="field-text__input"
															v-model="fieldsVal.natural.personInfoLastname"
											>
										</span>
									</label>
								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Имя <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input	type="text" 
															placeholder="Имя" 
															class="field-text__input"
															v-model="fieldsVal.natural.personInfoFirstname"
											>
										</span>
									</label>
								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Отчество <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="Отчество" 
															class="field-text__input"
															v-model="fieldsVal.natural.personInfoPatronymic"
											>
										</span>
									</label>
								</div>

								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">E-mail <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="E-mail" 
															class="field-text__input"
															v-model="fieldsVal.natural.personInfoEmail"
											>
										</span>
									</label>
								</div>

								<label class="field-text">
									<span class="field-text__name">Телефон <span style="color: red;">*</span></span>
									<span class="field-text__input-wrap">
										<input 	type="text" 
														placeholder="+ 7 (___) ___ __ __" 
														class="field-text__input"
														v-model="fieldsVal.natural.personInfoPhone"
										>
									</span>
								</label>

							</fieldset>
						</div>
					</div>
					
					<div class="hr"></div>

					<!-- Паспортные данные -->
					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<fieldset class="form__fieldset">
								<legend class="form__legend">Паспортные данные</legend>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Серия</span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="Серия" 
															class="field-text__input"
															v-model="fieldsVal.natural.personPassportSeries"
											>
										</span>
									</label>
								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Номер <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="Номер" 
															class="field-text__input"
															v-model="fieldsVal.natural.personPassportNumber"
											>
										</span>
									</label>
								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Кем выдан <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="Кем выдан" 
															class="field-text__input"
															v-model="fieldsVal.natural.personPassportIssuedBy"
											>
										</span>
									</label>
								</div>

								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Дата выдачи <span style="color: red;">*</span></span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="Дата выдачи" 
															class="field-text__input"
															v-model="fieldsVal.natural.personPassportIssuedDate"
											>
										</span>
									</label>
								</div>

								<label class="field-text">
									<span class="field-text__name">Код подразделения <span style="color: red;">*</span></span>
									<span class="field-text__input-wrap">
										<input 	type="text" 
														placeholder="Код подразделения" 
														class="field-text__input"
														v-model="fieldsVal.natural.personPassportDepartmentCode"
										>
									</span>
								</label>

							</fieldset>
						</div>
					</div>
					
					<div class="hr"></div>

					<!-- Адрес -->
					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<fieldset class="form__fieldset">
								<legend class="form__legend">Адрес</legend>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Область</span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="Область" 
															class="field-text__input"
															v-model="fieldsVal.natural.personAddressRegion"
											>
										</span>
									</label>
								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Населенный пункт</span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="Населенный пункт" 
															class="field-text__input"
															v-model="fieldsVal.natural.personAddressCity"
											>
										</span>
									</label>
								</div>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">Улица</span>
										<span class="field-text__input-wrap">
											<input 	type="text" 
															placeholder="Улица" 
															class="field-text__input"
															v-model="fieldsVal.natural.personAddressStreet"
											>
										</span>
									</label>
								</div>

								<label class="field-text">
									<span class="field-text__name">Дом</span>
									<span class="field-text__input-wrap">
										<input 	type="text" 
														placeholder="Дом" 
														class="field-text__input"
														v-model="fieldsVal.natural.personAddressBuilding"
										>
									</span>
								</label>

							</fieldset>
						</div>
					</div>

				</div>

				<div 	class="order-registration__stage-block"
							v-else-if="currentStage === 1"
				>
					<!-- Информация о транспорте -->


					<!-- Информация о транспорте -->
					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<fieldset class="form__fieldset">
								<legend class="form__legend">Информация о транспорте</legend>
								
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__input-wrap">
										
											<field-select 
												v-bind="wGroupSelect"
												:init="localRecord.wGroup"
												@change="selectTrans($event)"
											>
											</field-select>

										</span>
									</label>
								</div>

								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">
											Транспорт <span style="color: red;">*</span>
										</span>
										<span class="field-text__input-wrap">
											<input	type="text" 
															placeholder="Транспорт" 
															class="field-text__input"
															v-model="fieldsVal.juridical.companyContactPhone"
											>
										</span>
									</label>
								</div>

								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">
											Гос. номер <span style="color: red;">*</span>
										</span>
										<span class="field-text__input-wrap">
											<input	type="text" 
															placeholder="Гос. номер" 
															class="field-text__input"
															v-model="fieldsVal.juridical.companyContactPhone"
											>
										</span>
									</label>
								</div>

								<label class="field-text">
									<span class="field-text__name">Комментарий</span>
									<span class="field-text__input-wrap">
										<textarea	class="field-text__input" 
															name="comment" 
															placeholder="Комментарий"
															v-model="fieldsVal.juridical.companyExtraComment"
										></textarea>
									</span>
								</label>

							</fieldset>
						</div>
					</div>

					<div class="hr"></div>

					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
							<fieldset class="form__fieldset">
								<legend class="form__legend">Транспортировка</legend>
								
								<div class="block_orange-b">
									<fieldset class="form__fieldset form__fieldset_address" ref="address">
										<label class="field-text">
											<span class="field-text__name">
												Область транспортировки<span style="color: red;">*</span>
											</span>
											<span class="field-text__input-wrap">
												<input 
													name="region"	
													type="text" 
													placeholder="Область" 
													class="field-text__input"
													@click="fiasInit()"
													v-model="localRecord.wAddress.region.name"
												/>
											</span>
										</label>
									</fieldset>
								</div>

							
								<div class="block_orange-b">
									<label class="field-text">
										<span class="field-text__name">
											Стоимость транспортировки за 1 км <span style="color: red;">*</span>
										</span>
										<span class="field-text__input-wrap">
											<input	type="text" 
															placeholder="Стоимость транспортировки" 
															class="field-text__input"
															v-model="fieldsVal.juridical.companyContactPhone"
											>
										</span>
									</label>
								</div>
								

							</fieldset>
						</div>
					</div>
				

					<div class="hr"></div>

					<div class="row">
						<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
								<fieldset class="form__fieldset form__fieldset_address">
								<legend class="form__legend">Характеристики</legend>

								<div class="block_purple-b" v-for="(unitItem, index) in wUnitAmounts">
									<div class="row">
										<div class="col-8 col-sm-8">
											<label class="field-text">
												<span class="field-text__name">Вместимость<span style="color: red;">*</span></span>
												<span class="field-text__input-wrap">
													<input 	
														name="street"
														type="text" 
														placeholder="Количество" 
														class="field-text__input"
														v-model="unitItem.amount"
													>
												</span>
											</label>
										</div>

										<div class="col-4 col-sm-4">
											<label class="field-text">
												<span class="field-text__input-wrap">
													<field-select 
														v-bind="wUnitsSelect"
														:init="unitItem"
														@change="test3(index,$event)"
													>
													</field-select>
												</span>
											</label>
										</div>

										<div class="add-btn" 
												 v-if="(index < (wUnitsSelect.options.length - 2))">
											<a class="btn  btn_secondary btn_icon" 
												href="javascript:void(0);"
												@click="addUnit(index)">
												<span class="btn__icon i-plus"></span>
											</a>
										</div>

									</div>
								</div>

							</fieldset>

						</div>
					</div>
				
				</div>

			</template>


			<!-- Action buttons -->
			<div class="field-actions">
				<div class="row">
					<div class="offset-sm-2 col-sm-8 offset-md-3 col-md-6">
						<div class="field-actions__text">
							<span style="color: red;">* </span>— поля, обязательные для заполнения
						</div>
					</div>
				</div>

				<div class="d-flex justify-content-between">
					<button type="button" 
									:class="['btn  btn_secondary', firstStage ? 'invisible' : '']"
									:disabled="firstStage"
									@click="prevStage"
					>Назад</button>

					<button
						class="btn  btn_primary" 
						v-if="lastStage"
						@click="orderProcessing"
						:disabled="!formFilledRight"
					>
					Добавить исполнителя
					</button>

					<button type="button"
									class="btn  btn_primary" 
									@click="nextStage"
									v-else
					>Далее</button>
				</div>

			</div>

		</form>
	</div>
	`
})