// const ready = require('./utils/documentReady.js');

// ready(function(){
//   console.log('DOM героически построен!');
// });

// const $ = require('jquery');
// $( document ).ready(function() {});

/* eslint-disable */

import $ from "jquery";

import "slick-carousel/slick/slick.min.js";

$(".inner-carousel").slick({
  infinite: false,
  arrows: true,
  dots: true,
  slidesToShow: 1,
  slidesToScroll: 1,
});

$(".banners-row-field").slick({
  infinite: false,
  arrows: false,
  dots: true,
  slidesToShow: 4,
  slidesToScroll: 4,
  responsive: [
    {
      breakpoint: 1200,
      settings: {
        slidesToShow: 3,
        slidesToScroll: 3,
      },
    },
    {
      breakpoint: 768,
      settings: {
        slidesToShow: 2,
        slidesToScroll: 2,
      },
    },
    {
      breakpoint: 425,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
      },
    },
  ],
});

class Application {
  init() {
    this.onMobile();
    this.turnParallax();
    this.upButton();
    this.yearsFilter();
    this.imageClick();
    this.fixedMenu();
  }

  fixedMenu() {
    const headerMenu = document.querySelector(".header .header-menu-bottom");

    window.addEventListener("scroll", () => {
      if (pageYOffset > 180) {
        headerMenu.classList.add("_active");
      } else {
        headerMenu.classList.remove("_active");
      }
    });
  }

  darkPlaceRender(target, item) {
    const dark = document.createElement("div");
    const image = target.querySelector("img");

    dark.classList.add("dark");
    target.prepend(dark);

    setTimeout(() => {
      dark.classList.add("_active");
    });

    dark.addEventListener("click", () => {
      dark.classList.remove("_active");
      item.removeAttribute("style");
      image.removeAttribute("style");
      setTimeout(() => {
        dark.remove();
      }, 500);
    });
  }

  yearsFilter() {
    const yearsFilter = document.querySelector(".videos-years__filter");
    const yearsCurrent = document.querySelector(".videos-years__current");

    if (yearsFilter) {
      const dateInput = document.querySelector(
        '.videos-years__filter + input[type="date"]'
      );

      dateInput.addEventListener("change", () => {
        const dateInputValue = dateInput.value.split("-").reverse().join(".");

        yearsCurrent.textContent = dateInputValue;
      });

      console.log(dateInput);
    }
  }

  imageClick() {
    const allClickedImages = document.querySelectorAll(".clicked");

    allClickedImages.forEach((image) => {
      let dark = false;

      image.addEventListener("click", (e) => {
        e.preventDefault();

        if (!dark) {
          const parentElement = image.parentElement;
          this.darkPlaceRender(parentElement, image);

          image.style.position = "fixed";
          image.style.top = "50%";
          image.style.left = "50%";
          image.style.transform = "translate(-50%, -50%)";
          image.style.width = "auto";
          image.style.height = "auto";
          image.style.zIndex = "99";

          dark = true;
        }
      });
    });
  }

  onMobile() {
    const headerBurgerButton = document.querySelector(
      ".header .header-menu-bottom .header-menu-bottom__list li:first-child"
    );
    const fullHeaderMenu = document.querySelector(".header .header-full");
    const fullHeaderButton = document.querySelector(
      ".header .header-full .header-full__close"
    );

    headerBurgerButton.addEventListener("click", () => {
      fullHeaderMenu.classList.add("_active");

      document.body.style.overflow = "hidden";
    });

    fullHeaderButton.addEventListener("click", () => {
      fullHeaderMenu.classList.remove("_active");

      document.body.removeAttribute("style");
    });

    const mobileMenuButton = document.querySelector(
      ".header .header-menu-mobile .header-menu-mobile__button"
    );
    const mobileLogo = document.querySelector(
      ".header .header-menu-mobile .header-menu-mobile__logo"
    );
    const mobileMenu = document.querySelector(
      ".header .header-menu-mobile .header-menu-mobile__more"
    );

    mobileMenuButton.addEventListener("click", () => {
      if (mobileMenu.classList.contains("_active")) {
        mobileLogo.removeAttribute("style");
        mobileMenu.classList.remove("_active");
        mobileMenuButton.classList.remove("_active");
      } else {
        mobileLogo.style.visibility = "hidden";
        mobileMenu.classList.add("_active");
        mobileMenuButton.classList.add("_active");
      }
    });

    const mobileMenuList = document.querySelectorAll(
      ".header .header-menu-mobile .header-menu-mobile__more .mobile__more-list .mobile__more-list__item"
    );

    mobileMenuList.forEach((li) => {
      const liMore = li.querySelector("._inner-list");

      li.addEventListener("click", () => {
        if (liMore.classList.contains("_active")) {
          li.classList.remove("_active");
          liMore.classList.remove("_active");
        } else {
          li.classList.add("_active");
          liMore.classList.add("_active");
        }
      });
    });
  }

  turnParallax() {
    const parallaxItems = document.querySelectorAll("[parallax]");
    const windowHeight = window.pageYOffset;

    if (parallaxItems) {
      window.addEventListener("scroll", () => {
        parallaxItems.forEach((item) => {
          const currentOffset = item.getBoundingClientRect().y;
          const currentSpeed = item.getAttribute("parallax");

          if (currentOffset < windowHeight) {
            item.style.transform = `translateY(${
              currentOffset / currentSpeed
            }px)`;
          }
        });
      });
    }
  }

  upButton() {
    const upButton = document.querySelector(".up-button");

    window.addEventListener("scroll", () => {
      if (pageYOffset > window.innerHeight) {
        upButton.classList.add("_active");
      } else {
        upButton.classList.remove("_active");
      }
    });

    upButton.addEventListener("click", (e) => {
      e.preventDefault();

      window.scrollTo({
        top: 0,
        left: 0,
        behavior: "smooth",
      });
    });
  }
}

const radon = new Application();

radon.init();
