/* global module */

let config = {
  notGetBlocks: ["blocks-demo.html"],
  ignoredBlocks: ["no-js"],
  alwaysAddBlocks: [
    "page-header",
    "page-footer",
    // 'sprite-svg',
    // 'sprite-png',
    // 'object-fit-polyfill',
  ],
  addStyleBefore: [
    "src/scss/variables.scss",
    "src/scss/mixins.scss",
    // 'somePackage/dist/somePackage.css', // для 'node_modules/somePackage/dist/somePackage.css',
  ],
  addStyleAfter: ["src/scss/main.scss"],
  addJsBefore: [
    // 'somePackage/dist/somePackage.js', // для 'node_modules/somePackage/dist/somePackage.js',
  ],
  addJsAfter: ["./script.js"],
  addAssets: {
    "src/img/*.{png,svg,jpg,jpeg,svg}": "img/",
    "src/fonts/Rosatom-Italic.ttf": "fonts/",
    "src/fonts/Rosatom-Light.ttf": "fonts/",
    "src/fonts/Rosatom-Regular.ttf": "fonts/",
    "src/fonts/Rosatom-Bold.ttf": "fonts/",
    // 'src/favicon/*.{png,ico,svg,xml,webmanifest}': 'img/favicon',
    // 'node_modules/somePackage/images/*.{png,svg,jpg,jpeg}': 'img/',
  },
  dir: {
    src: "src/",
    build: "build/",
    blocks: "src/blocks/",
  },
};

module.exports = config;
