# Стартовый проект с gulp

Установка: выполнить в папке проекта: `npm i`.

Использование: `npm start` (дабы не ставить глобально 4-ю версию gulp, которая сейчас в альфе). После `npm start` можно через пробел указать задачу. К примеру `npm start less` выполнит только задачу `less` из `gulpfile.js` (полный список задач смотри в `gulpfile.js`).

`port=3004 npm start` — для запуска сервера автообновлений на указанном порту.

`NODE_ENV=production npm start [задача]` — для запуска задач без создания sourcemaps.



## Парадигма

- Используется именование классов и файлов по БЭМ.
- Каждый БЭМ-блок в своей папке внутри `/src/blocks/` (less, js, картинки, разметка; обязателен только less-файл).
- Есть глобальные файлы: css, js, шрифты, картинки, less-файлы (переменные, глобальная стилизация...).
- Есть диспетчер подключений `/src/less/style.less`. Если в нем импортирован less-файл какого-либо блока, этот блок считается используемым (обрабатывается его js и доп. файлы).
- Для разметки можно использовать [микрошаблонизацию](https://www.npmjs.com/package/gulp-file-include) — обычное включение разметки мелких файлов внутрь больших файлов с возможностью передавать какие-то данные в мелкие файлы. А можно и не использовать.



### Проверка кода

Перед коммитом происходит проверка LESS. Если проверка не пройдена, коммит не будет создан. В этом случае нужно исправить код в соответствии с подсказками в консоли, заново проиндексировать файлы и создать коммит. 

Если новый файл содержит конструкции, рагантировано не проходящие проверку (двойные кавычки внутри требуемых одинарных, условия в примесях), можно добавить его в игнор проверки — в файл `.lesshintrc`.



### Блоки

Каждый блок лежит в `/src/blocks/` в своей папке. Каждый блок — как минимум, папка и одноимённый less-файл.

Возможное содержимое блока:

```bash
block-name/               # Папка блока
  img/                    # Изображения, используемые блоком и обрабатываемые автоматикой сборки
  img_to_bg/              # Изображения, не обрабатываемые автоматикой сборки  
  demo-block.less         # Главный стилевой файл блока
  demo-block--mod.less    # Отдельный файл модификатора блока (если объемный и нужен не на всех проектах)
  demo-block.js           # Главный js-файл блока
  demo-block--mod.js      # js-файл для отдельного модификатора блока
  demo-block.html         # Варианты разметки (как документация блока или как вставляемый микрошаблонизатором фрагмент)
  demo-block.css          # Добавочный css (копируется как отдельный файл в `build/css`)
  readme.md               # Какое-то пояснение
```

### Удобное создание нового блока


```bash
# формат: node createBlock.js [имя блока] [доп. расширения через пробел]
node createBlock.js block # создаст только папку, block.html и block.less
node createBlock.js new-block js jade # создаст папку, new-block.html, new-block.less, new-block.js, new-block.jade
```

По умолчанию будут созданы `.html` и `.less` файлы, в них будет записан стартовый контент.

Если блок уже существует, файлы не будут затёрты, но создадутся те файлы, которые ещё не существуют.



## Подключение блоков

Если в диспетчере подключений (`./src/less/style.less`):

```
@import './src/blocks/demo-block/demo-block.less';
```

То указанный файл будет взят в компиляцию стилей, а так же:
- в обработку будет взят js-файл блока: `./src/blocks/demo-block/demo-block.js` (если существует и не пустой, будет конкатенирован с прочими js-файлами и углифицирован)
- в обработку будет взят css-файл блока: `./src/blocks/demo-block/demo-block.css` (если существует и не пустой, будет скопирован в папку сборки и минифицирован)
- в обработку будут добавлены все картинки блока: `./src/blocks/demo-block/img/*.{jpg,jpeg,gif,png,svg}` (если в папке блока существует подпапка `img/`)

Если в диспетчере подключений:

```
@import './src/blocks/demo-block/demo-block.less';
@import './src/blocks/demo-block/demo-block--mod.less';
```

То указанные файлы будет взяты в компиляцию стилей, а так же:
- в обработку будет взят js-файл блока: `./src/blocks/demo-block/demo-block.js` (если существует и не пустой, будет конкатенирован с прочими js-файлами и углифицирован)
- в обработку будет взят js-файл блока: `./src/blocks/demo-block/demo-block--mod.js` (если существует и не пустой, будет конкатенирован с прочими js-файлами и углифицирован)
- в обработку будет взят css-файл блока: `./src/blocks/demo-block/demo-block.css` (если существует и не пустой, будет скопирован в папку сборки и минифицирован)
- в обработку будет взят css-файл блока: `./src/blocks/demo-block/demo-block--mod.css` (если существует и не пустой, будет скопирован в папку сборки и минифицирован)
- в обработку будут добавлены все картинки блока: `./src/blocks/demo-block/img/*.{jpg,jpeg,gif,png,svg}` (если в папке блока существует подпапка `img/`)



## Назначение папок

```bash
build/          # Сюда собирается проект, здесь работает сервер автообновлений.
src/            # Исходные файлы
  _include/     # - фрагменты html для самого верха (секция head) и самого низа (перед закрывающим body) страницы
  blocks/       # - блоки (компоненты) проекта 
  css/          # - глобальный css-файл (будет скопирован только если существует и не пустой)
  fonts/        # - шрифты проекта (никак не обрабатываются, см. http://jaicab.com/localFont/)
  img/          # - глобальные картинки (будут обработаны только из корня этой папки, подпапки игнорируются)
  js/           # - глобальный js-файл (обработается только если существует и не пустой)
  less/         # - диспетчер подключений и глобальные стили
  blocks_library.html   # библиотека блоков проекта
  index.html            # главная страница проекта
```


## Комментирование для разработчиков

Для разметочных файлов можно использовать комментарии вида `<!--DEV Комментарий -->` — такие комментарии не попадут в собранный html.
