# Стартовый проект с gulp

[![David](https://img.shields.io/david/dev/nicothin/NTH-start-project.svg?style=flat-square)]()

ВНИМАНИЕ! Этот проект в разработке (призван систематизировать мои личные наработки из области вёрстки), я добавляю и меняю в нем довольно много всего. Это даже не альфа. Периодически может выглядеть странно и не менее странно работать.

Установка: `npm i`.

Использование: `npm start`. После `npm start` можно через пробел указать задачу. К примеру `npm start less` выполнит только задачу `less` из `gulpfile.js` (полный список задач смотри в `gulpfile.js`).

`npm run build` — сборка проекта без карт кода (минифицированый вид, как результат работы).

`npm run deploy` — сборка проекта без карт кода и отправка содержимого папки сборки на GH-pages (для корректного сообщения адреса просмотра введите его в `package.json`).

`npm test` — запуск проверки `.less`-файлов Stylelint-ом.

`port=3004 npm start` — для запуска сервера автообновлений на указанном порту.



## Парадигма

- Используется именование классов и файлов по БЭМ.
- Каждый БЭМ-блок в своей папке внутри `/src/blocks/` (less, js, картинки, разметка; обязателен только less-файл).
- Есть глобальные файлы: css, js, шрифты, картинки, less-файлы (переменные, глобальная стилизация...).
- Есть диспетчер подключений `/src/less/style.less`. Если в нем импортирован less-файл какого-либо блока, этот блок считается используемым (обрабатывается его js и доп. файлы).
- Для разметки можно использовать [микрошаблонизацию](https://www.npmjs.com/package/gulp-file-include) — обычное включение разметки мелких файлов внутрь больших файлов с возможностью передавать какие-то данные в мелкие файлы. А можно и не использовать.
- **Перед коммитом происходит проверка `.less`-файлов** на соответствие правилам Stylelint (см. `.stylelintrc` в корне проекта). Если выявлены ошибки, коммит не будет создан, нужно исправить ошибки, переиндексировать файлы и сделать коммит.



### Блоки

Каждый блок лежит в `/src/blocks/` в своей папке. Каждый блок — как минимум, папка и одноимённый less-файл.

Возможное содержимое блока:

```bash
demo-block/               # Папка блока
  img/                    # Изображения, используемые блоком и обрабатываемые автоматикой сборки
  some-folder/            # Какая-то сторонняя папка, не обрабатываемые автоматикой
  demo-block.less         # Главный стилевой файл блока
  demo-block--mod.less    # Отдельный файл БЭМ-модификатора блока
  demo-block.js           # Главный js-файл блока
  demo-block--mod.js      # js-файл для отдельного БЭМ-модификатора блока
  demo-block.html         # Варианты разметки (как документация блока или как вставляемый микрошаблонизатором фрагмент)
  demo-block.css          # Добавочный css (копируется как отдельный файл в `build/css`)
  readme.md               # Какое-то пояснение
```

### Удобное создание нового блока


```bash
# формат: node createBlock.js [имя блока] [доп. расширения через пробел]
node createBlock.js block # создаст только папку блока, block.html и block.less
node createBlock.js new-block js jade # создаст папку блока, new-block.html, new-block.less, new-block.js, new-block.jade
node createBlock.js new-block js img # создаст папку блока, new-block.html, new-block.less, new-block.js, подпапку img/
```

По умолчанию будут созданы `.html` и `.less` файлы, в них будет записан стартовый контент.

Если блок уже существует, файлы не будут затёрты, но создадутся те файлы, которые ещё не существуют.

После создания блока, в диспетчер подключений будет дописана (в самый низ) строка импорта стилевого файла.



## Подключение блоков

Если в диспетчере подключений (файле `./src/less/style.less`):

```less
@import './src/blocks/demo-block/demo-block.less';
```

То указанный файл будет взят в компиляцию стилей, а так же:
- в обработку будет взят js-файл блока: `./src/blocks/demo-block/demo-block.js` (если существует и не пустой, будет конкатенирован с прочими js-файлами и углифицирован)
- в обработку будет взят css-файл блока: `./src/blocks/demo-block/demo-block.css` (если существует и не пустой, будет скопирован в папку сборки и минифицирован)
- в обработку будут добавлены все картинки блока: `./src/blocks/demo-block/img/*.{jpg,jpeg,gif,png,svg}` (если в папке блока существует подпапка `img/`)

Если в диспетчере подключений:

```
@import './src/blocks/demo-block/demo-block.less';
@import './src/blocks/demo-block/demo-block--mod.less';
```

То указанные файлы будет взяты в компиляцию стилей, а так же:
- в обработку будет взят js-файл блока: `./src/blocks/demo-block/demo-block.js` (если существует и не пустой, будет конкатенирован с прочими js-файлами и углифицирован)
- в обработку будет взят js-файл блока: `./src/blocks/demo-block/demo-block--mod.js` (если существует и не пустой, будет конкатенирован с прочими js-файлами и углифицирован)
- в обработку будет взят css-файл блока: `./src/blocks/demo-block/demo-block.css` (если существует и не пустой, будет скопирован в папку сборки и минифицирован)
- в обработку будет взят css-файл блока: `./src/blocks/demo-block/demo-block--mod.css` (если существует и не пустой, будет скопирован в папку сборки и минифицирован)
- в обработку будут добавлены все картинки блока: `./src/blocks/demo-block/img/*.{jpg,jpeg,gif,png,svg}` (если в папке блока существует подпапка `img/`)



## Назначение папок

```bash
build/          # Сюда собирается проект, здесь работает сервер автообновлений.
src/            # Исходные файлы
  _include/     # - фрагменты html для самого верха (секция head) и самого низа (перед закрывающим body) страницы
  blocks/       # - блоки (компоненты) проекта
  css/          # - глобальные css-файлы (будут скопированы только если существует и не пустые)
  fonts/        # - шрифты проекта (будут скопированы в папку сборки, подпапку fonts/)
  img/          # - глобальные картинки (будут обработаны только из корня этой папки, подпапки игнорируются)
  js/           # - глобальный js-файл (обработается только если существует и не пустой), фреймворки (только копируются, могут быть подключены вручную)
  less/         # - диспетчер подключений и глобальные стили
  blocks_library.html   # библиотека блоков проекта
  index.html            # главная страница проекта
```



## Комментирование для разработчиков

Для разметочных файлов можно использовать комментарии вида `<!--DEV Комментарий -->` — такие комментарии не попадут в собранный html.



## Выгрузка на gh-pages

Содержимое проекта можно быстро «выгрузить» на [gh-pages](https://help.github.com/articles/user-organization-and-project-pages/#project-pages) (автоматически запушить содержимое папки `build/` в ветку `gh-pages` репозитория проекта). Адрес для просмотра будет таким: http://USERNAME.github.io/PROJECTNAME/ (полное повторений файловой структуры папки `build/`).


```bash
npm run deploy    # собрать проект без карт кода и отправить на gh-pages
```
