'use strict';

// Генератор файлов блока

// Использование: node createBlock.js [имя блока] [доп. расширения через пробел]

const fs = require('fs');                // будем работать с файловой системой
const pjson = require('./package.json'); // получим настройки из package.json
const dirs = pjson.configProject.dirs;   // отдельно имеем объект с директориями
const mkdirp = require('mkdirp');        // зависимость

let blockName = process.argv[2];          // получим имя блока
let defaultExtensions = ['scss', 'html', 'img']; // расширения по умолчанию
let extensions = uniqueArray(defaultExtensions.concat(process.argv.slice(3)));  // добавим введенные при вызове расширения (если есть)

// Если есть имя блока
if(blockName) {

  let dirPath = dirs.srcPath + dirs.blocksDirName + '/' + blockName + '/'; // полный путь к создаваемой папке блока
  mkdirp(dirPath, function(err){                                           // создаем

    // Если какая-то ошибка — покажем
    if(err) {
      console.error('[NTH] Отмена операции: ' + err);
    }

    // Нет ошибки, поехали!
    else {
      console.log('[NTH] Создание папки ' + dirPath + ' (если отсутствует)');

      // Обходим массив расширений и создаем файлы, если они еще не созданы
      extensions.forEach(function(extention){

        let filePath = dirPath + blockName + '.' + extention; // полный путь к создаваемому файлу
        let fileContent = '';                                 // будущий контент файла
        let fileCreateMsg = '';                               // будущее сообщение в консоли при создании файла

        // Если это SCSS
        if(extention == 'scss') {
          fileContent = '// В этом файле должны быть стили только для БЭМ-блока ' + blockName + ', его элементов, \n// модификаторов, псевдоселекторов, псевдоэлементов, @media-условий...\n// Не пишите здесь другие селекторы.\n\n.' + blockName + ' {\n  \n}\n';
          // fileCreateMsg = '';

          // Добавим созданный файл в ./package.json
          let hasThisBlock = false;
          for (let block in pjson.configProject.blocks) {
            if(block === blockName) {
              hasThisBlock = true;
              break;
            }
          }
          if(!hasThisBlock) {
            pjson.configProject.blocks[blockName] = [];
            let newPackageJson = JSON.stringify(pjson, "", 2);
            fs.writeFileSync('./package.json', newPackageJson);
            fileCreateMsg = '[NTH] Подключение блока добавлено в package.json';
          }
        }

        // Если это HTML
        else if(extention == 'html') {
          fileContent = '<!--DEV\n\nДля использования этого файла как шаблона:\n\n@ @include(\'blocks/' + blockName + '/' + blockName + '.html\')\n\n(Нужно убрать пробел между символами @)\nПодробнее: https://www.npmjs.com/package/gulp-file-include-->\n\n<div class="' + blockName + '">content</div>\n';
          // fileCreateMsg = '';
        }

        // Если это JS
        else if(extention == 'js') {
          fileContent = '// (function(){\n// код\n// }());\n';
        }

        // Если нужна подпапка для картинок
        else if(extention == 'img') {
          let imgFolder = dirPath + 'img/';
          if(fileExist(imgFolder) === false) {
            mkdirp(imgFolder, function (err) {
              if (err) console.error(err)
              else console.log('[NTH] Создание папки: ' + imgFolder + ' (если отсутствует)')
            });
          }
          else {
            console.log('[NTH] Папка '+imgFolder+' НЕ создана (уже существует) ')
          }
        }

        // Создаем файл, если он еще не существует
        if(fileExist(filePath) === false && extention !== 'img') {
          fs.writeFile(filePath, fileContent, function(err) {
            if(err) {
              return console.log('[NTH] Файл НЕ создан: ' + err);
            }
            console.log('[NTH] Файл создан: ' + filePath);
            if(fileCreateMsg) {
              console.warn(fileCreateMsg);
            }
          });
        }
        else if(extention !== 'img') {
          console.log('[NTH] Файл НЕ создан: ' + filePath + ' (уже существует)');
        }
      });
    }
  });
}
else {
  console.log('[NTH] Отмена операции: не указан блок');
}

// Оставить в массиве только уникальные значения (убрать повторы)
function uniqueArray(arr) {
  var objectTemp = {};
  for (var i = 0; i < arr.length; i++) {
    var str = arr[i];
    objectTemp[str] = true; // запомнить строку в виде свойства объекта
  }
  return Object.keys(objectTemp);
}

// Проверка существования файла
function fileExist(path) {
  const fs = require('fs');
  try {
    fs.statSync(path);
  } catch(err) {
    return !(err && err.code === 'ENOENT');
  }
}
