/*
  Поиск ближайшего родителя по селектору
  https://github.com/oneuijs/You-Dont-Need-jQuery/blob/master/README-ru.md#1.6
*/

function closest(el, selector) {
  const matchesSelector = el.matches || el.webkitMatchesSelector || el.mozMatchesSelector || el.msMatchesSelector;

  while (el) {
    if (matchesSelector.call(el, selector)) {
      return el;
    } else {
      el = el.parentElement;
    }
  }
  return null;
}



/*
  Запуск по готовности DOM
  http://youmightnotneedjquery.com/#ready
  Применение: ready(function(){ console.log('ddd'); });
*/

function ready(fn) {
  if (document.readyState != 'loading'){
    fn();
  } else {
    document.addEventListener('DOMContentLoaded', fn);
  }
}



/*
  При добавлении новых дополнительных функций, изолируйте их!
*/

// (function(){
//   // код
// }());





// Свой код с jQuery

// $( document ).ready(function() {

// });
